/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.htmlparser.parser;

import org.tinygroup.htmlparser.HtmlDocument;
import org.tinygroup.htmlparser.HtmlNodeType;
import org.tinygroup.htmlparser.node.HtmlNode;
import org.tinygroup.parser.NodeType;
import org.tinygroup.parser.Parser;

public abstract class HtmlParser<Source>
implements Parser<HtmlNode, HtmlDocument, Source> {
    private static String startPattern = null;

    static String getHeadEndPattern(NodeType nt) {
        if (nt.getHead() != null && nt.getHead().getEnd() != null) {
            return HtmlParser.replaceSpecialChar(nt.getHead().getEnd());
        }
        return null;
    }

    static String getTailStartPattern(NodeType nt) {
        if (nt.getTail() != null && nt.getTail().getStart() != null) {
            return HtmlParser.replaceSpecialChar(nt.getTail().getStart());
        }
        return null;
    }

    static String getTailEndPattern(NodeType nt) {
        if (nt.getTail() != null && nt.getTail().getEnd() != null) {
            return HtmlParser.replaceSpecialChar(nt.getTail().getEnd());
        }
        return null;
    }

    static String getHeadStartPattern() {
        if (startPattern != null) {
            return startPattern;
        }
        StringBuffer pattern = new StringBuffer("<[/]|[/]>");
        for (HtmlNodeType nt : HtmlNodeType.values()) {
            String sn;
            if (nt.getHead() == null || (sn = nt.getHead().getStart()) == null) continue;
            if (pattern.length() > 0) {
                pattern.append("|");
            }
            pattern.append(HtmlParser.replaceSpecialChar(sn));
        }
        startPattern = pattern.toString();
        return startPattern;
    }

    private static String replaceSpecialChar(String sn) {
        StringBuffer sb = new StringBuffer();
        block7: for (int i = 0; i < sn.length(); ++i) {
            char c = sn.charAt(i);
            switch (c) {
                case '[': {
                    sb.append("\\[");
                    continue block7;
                }
                case ']': {
                    sb.append("\\]");
                    continue block7;
                }
                case '?': {
                    sb.append("\\?");
                    continue block7;
                }
                case '!': {
                    sb.append("\\!");
                    continue block7;
                }
                case '-': {
                    sb.append("\\-");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }
}

