/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.htmlparser.parser;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tinygroup.htmlparser.HtmlDocument;
import org.tinygroup.htmlparser.HtmlNodeType;
import org.tinygroup.htmlparser.document.HtmlDocumentImpl;
import org.tinygroup.htmlparser.node.HtmlNode;
import org.tinygroup.htmlparser.parser.HtmlParser;
import org.tinygroup.parser.Node;

public class HtmlStringParser
extends HtmlParser<String> {
    public static final String HEAD_END_PATTERN = "HeadEndPattern";
    private static final String TAIL_END_PATTERN = "TailEndPattern";
    private static Pattern endTagName = Pattern.compile("(\\w|[\u4e00-\u9fa5]|[.]|[:]|[-])+\\s*>");
    private static Pattern startTagName = Pattern.compile("(\\w|[\u4e00-\u9fa5]|[-]|[:]|[.])+");
    private static Pattern attribute = Pattern.compile("(\\b(\\w|[\u4e00-\u9fa5]|[/]|[:]|[.]|[-])+\\s*=\\s*\"[^\"]*\")|(\\b(\\w|[\u4e00-\u9fa5]|[/]|[.]|[:]|[-])+\\s*=\\s*'[^']*')|(\\b(\\w|[\u4e00-\u9fa5]|[/]|[.]|[-])+\\s*=\\s*(\\w|[\u4e00-\u9fa5]|[.]|[-])+)|(\\w|[\u4e00-\u9fa5]|[.]|[:]|[-])+");
    private static Map<String, Pattern> patternTable = new HashMap<String, Pattern>();
    private int start = 0;

    private String parseNode(String htmlSource, HtmlNode pnode) {
        Pattern pattern = Pattern.compile(HtmlStringParser.getHeadStartPattern());
        Matcher matcher = pattern.matcher(htmlSource);
        matcher.region(this.start, htmlSource.length());
        block0: while (matcher.find()) {
            String headStart;
            if (this.start < matcher.start()) {
                String str = htmlSource.substring(this.start, matcher.start());
                if (str.trim().length() > 0) {
                    HtmlNode node = new HtmlNode(HtmlNodeType.TEXT);
                    node.setContent(str);
                    pnode.addNode((Node)node);
                }
                this.start = matcher.start();
            }
            if ((headStart = htmlSource.substring(matcher.start(), matcher.end())).equals("/>")) {
                this.start = matcher.end();
                return null;
            }
            if (headStart.equals("</")) {
                Matcher m = endTagName.matcher(htmlSource);
                m.region(this.start, htmlSource.length());
                if (m.find()) {
                    this.start = m.end();
                    String r = htmlSource.substring(m.start(), m.end() - 1).trim();
                    if (r.length() == 0) {
                        return null;
                    }
                    if (r.equals(pnode.getNodeName())) {
                        return null;
                    }
                    return r;
                }
            }
            for (HtmlNodeType nodetype : HtmlNodeType.values()) {
                Matcher m;
                Pattern p;
                Matcher m2;
                if (nodetype.getHead() == null || nodetype.getHead().getStart() == null || !nodetype.getHead().getStart().equals(headStart)) continue;
                HtmlNode node = new HtmlNode(nodetype);
                pnode.addNode((Node)node);
                if (nodetype == HtmlNodeType.ELEMENT) {
                    m2 = startTagName.matcher(htmlSource);
                    m2.region(this.start, htmlSource.length());
                    if (m2.find()) {
                        node.setNodeName(htmlSource.substring(m2.start(), m2.end()));
                        this.start = m2.end();
                    }
                }
                if (nodetype.isHasHeader()) {
                    m2 = attribute.matcher(htmlSource);
                    m2.region(this.start, htmlSource.indexOf(62, matcher.end()));
                    this.parseHeader(htmlSource, node, m2);
                }
                if (nodetype.getHead().getEnd() != null) {
                    p = patternTable.get((Object)((Object)nodetype) + HEAD_END_PATTERN);
                    if (p == null) {
                        p = Pattern.compile(HtmlStringParser.getHeadEndPattern(nodetype));
                        patternTable.put((Object)((Object)nodetype) + HEAD_END_PATTERN, p);
                    }
                    m = p.matcher(htmlSource);
                    m.region(this.start, htmlSource.length());
                    if (m.find()) {
                        char c = htmlSource.charAt(m.start() - 1);
                        this.start = m.end();
                        if (c != '/') {
                            if (nodetype.isHasBody()) {
                                String r = this.parseNode(htmlSource, node);
                                if (r != null) {
                                    if (r.endsWith(pnode.getNodeName())) {
                                        return null;
                                    }
                                    return r;
                                }
                                matcher.region(this.start, htmlSource.length());
                                continue block0;
                            }
                        } else {
                            matcher.region(this.start, htmlSource.length());
                            continue block0;
                        }
                    }
                }
                if (nodetype.getTail() == null || nodetype.getTail().getEnd() == null) continue;
                p = patternTable.get((Object)((Object)nodetype) + TAIL_END_PATTERN);
                if (p == null) {
                    p = Pattern.compile(HtmlStringParser.getTailEndPattern(nodetype));
                    patternTable.put((Object)((Object)nodetype) + TAIL_END_PATTERN, p);
                }
                m = p.matcher(htmlSource);
                m.region(matcher.end(), htmlSource.length());
                if (!m.find()) continue;
                node.setContent(htmlSource.substring(matcher.end(), m.start()));
                this.start = m.end();
                matcher.region(this.start, htmlSource.length());
                continue block0;
            }
        }
        return null;
    }

    private void parseHeader(String htmlSource, HtmlNode node, Matcher m) {
        while (m.find()) {
            String str = htmlSource.substring(m.start(), m.end());
            if (str.indexOf(61) > 0) {
                String k = str.substring(0, str.indexOf(61)).trim();
                String v = str.substring(str.indexOf(61) + 1).trim();
                if (v.startsWith("\"")) {
                    v = v.substring(1, v.length() - 1);
                } else if (v.startsWith("'")) {
                    v = v.substring(1, v.length() - 1);
                }
                node.setAttribute(k, v);
            } else {
                node.setAttribute(str, str);
            }
            this.start = m.end();
        }
    }

    public HtmlDocument parse(String htmlSource) {
        HtmlDocumentImpl document = new HtmlDocumentImpl();
        Pattern pattern = Pattern.compile(HtmlStringParser.getHeadStartPattern());
        Matcher matcher = pattern.matcher(htmlSource);
        HtmlNode rootNode = new HtmlNode(HtmlNodeType.ELEMENT);
        document.setRoot((Node)rootNode);
        block0: while (matcher.find()) {
            this.start = matcher.end();
            String headStart = matcher.group();
            for (HtmlNodeType nt : HtmlNodeType.values()) {
                Matcher m;
                Pattern p;
                Matcher m2;
                if (nt.getHead() == null || nt.getHead().getStart() == null || !nt.getHead().getStart().equals(headStart)) continue;
                HtmlNode node = new HtmlNode(nt);
                if (nt == HtmlNodeType.ELEMENT) {
                    rootNode.addNode((Node)node);
                } else if (nt == HtmlNodeType.COMMENT) {
                    document.addComment(node);
                } else if (nt == HtmlNodeType.DOCTYPE) {
                    document.addDoctype(node);
                } else if (nt == HtmlNodeType.PROCESSING_INSTRUCTION) {
                    document.addProcessingInstruction(node);
                }
                if (nt == HtmlNodeType.ELEMENT) {
                    m2 = startTagName.matcher(htmlSource);
                    m2.region(this.start, htmlSource.length());
                    if (m2.find()) {
                        node.setNodeName(htmlSource.substring(m2.start(), m2.end()));
                        this.start = m2.end();
                    }
                }
                if (nt.isHasHeader()) {
                    m2 = attribute.matcher(htmlSource);
                    m2.region(this.start, htmlSource.indexOf(62, matcher.end()));
                    this.parseHeader(htmlSource, node, m2);
                }
                if (nt.getHead().getEnd() != null) {
                    p = patternTable.get((Object)((Object)nt) + HEAD_END_PATTERN);
                    if (p == null) {
                        p = Pattern.compile(HtmlStringParser.getHeadEndPattern(nt));
                        patternTable.put((Object)((Object)nt) + HEAD_END_PATTERN, p);
                    }
                    m = p.matcher(htmlSource);
                    m.region(this.start, htmlSource.length());
                    if (m.find()) {
                        this.start = m.end();
                        if (nt.isHasBody()) {
                            this.parseNode(htmlSource, node);
                            matcher.region(this.start, htmlSource.length());
                            continue block0;
                        }
                    }
                }
                if (nt.getTail() == null || nt.getTail().getEnd() == null) continue;
                p = patternTable.get((Object)((Object)nt) + TAIL_END_PATTERN);
                if (p == null) {
                    p = Pattern.compile(HtmlStringParser.getTailEndPattern(nt));
                    patternTable.put((Object)((Object)nt) + TAIL_END_PATTERN, p);
                }
                m = p.matcher(htmlSource);
                m.region(this.start, htmlSource.length());
                if (!m.find()) continue;
                node.setContent(htmlSource.substring(matcher.end(), m.start()));
                this.start = m.end();
                matcher.region(this.start, htmlSource.length());
                continue block0;
            }
        }
        HtmlNode root = (HtmlNode)document.getRoot();
        if (root.getNodeName() == null && root.getNodeType() == HtmlNodeType.ELEMENT && root.getSubNodes().size() == 1) {
            document.setRoot((Node)root.getSubNodes().get(0));
        }
        return document;
    }
}

