/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.menucommand.fileresolver;

import com.thoughtworks.xstream.XStream;
import org.tinygroup.fileresolver.impl.AbstractFileProcessor;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.menucommand.MenuConfigManager;
import org.tinygroup.menucommand.config.MenuConfigs;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.xstream.XStreamFactory;

public class MenuConfigFileProcessor
extends AbstractFileProcessor {
    private static final String MENU_URL_NAME = ".menuconfig";
    private static final String XSTEAM_PACKAGE_NAME = "menuconfig";
    private MenuConfigManager menuConfigManager;

    public MenuConfigManager getMenuConfigManager() {
        return this.menuConfigManager;
    }

    public void setMenuConfigManager(MenuConfigManager menuConfigManager) {
        this.menuConfigManager = menuConfigManager;
    }

    public void process() {
        XStream stream = XStreamFactory.getXStream((String)XSTEAM_PACKAGE_NAME);
        for (FileObject fileObject : this.deleteList) {
            LOGGER.logMessage(LogLevel.INFO, "\u6b63\u5728\u79fb\u9664\u83dc\u5355\u547d\u4ee4\u914d\u7f6e\u6587\u4ef6[{0}]", new Object[]{fileObject.getAbsolutePath()});
            MenuConfigs menuConfigs = (MenuConfigs)this.caches.get(fileObject.getAbsolutePath());
            if (menuConfigs != null) {
                this.menuConfigManager.removeMenuConfigs(menuConfigs);
                this.caches.remove(fileObject.getAbsolutePath());
            }
            LOGGER.logMessage(LogLevel.INFO, "\u79fb\u9664\u83dc\u5355\u547d\u4ee4\u914d\u7f6e\u6587\u4ef6[{0}]\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
        }
        for (FileObject fileObject : this.changeList) {
            MenuConfigs menuConfigs;
            LOGGER.logMessage(LogLevel.INFO, "\u6b63\u5728\u52a0\u8f7d\u83dc\u5355\u547d\u4ee4\u914d\u7f6e\u6587\u4ef6[{0}]", new Object[]{fileObject.getAbsolutePath()});
            MenuConfigs oldMenuConfigs = (MenuConfigs)this.caches.get(fileObject.getAbsolutePath());
            if (oldMenuConfigs != null) {
                this.menuConfigManager.removeMenuConfigs(oldMenuConfigs);
            }
            if ((menuConfigs = (MenuConfigs)stream.fromXML(fileObject.getInputStream())) != null) {
                this.menuConfigManager.addMenuConfigs(menuConfigs);
            }
            this.caches.put(fileObject.getAbsolutePath(), menuConfigs);
            LOGGER.logMessage(LogLevel.INFO, "\u52a0\u8f7d\u83dc\u5355\u547d\u4ee4\u914d\u7f6e\u6587\u4ef6[{0}]\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
        }
    }

    protected boolean checkMatch(FileObject fileObject) {
        return fileObject.getFileName().endsWith(MENU_URL_NAME) || fileObject.getFileName().endsWith(".menuconfig.xml");
    }
}

