/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.menucommand.config;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.List;
import org.tinygroup.menucommand.config.BaseObject;
import org.tinygroup.menucommand.config.MenuCommand;

@XStreamAlias(value="menu-config")
public class MenuConfig
extends BaseObject {
    @XStreamOmitField
    private MenuConfig parent;
    @XStreamImplicit
    private List<MenuConfig> menuConfigList;
    @XStreamImplicit
    private List<MenuCommand> menuCommandList;

    public List<MenuConfig> getMenuConfigList() {
        return this.menuConfigList;
    }

    public void setMenuConfigList(List<MenuConfig> menuConfigList) {
        this.menuConfigList = menuConfigList;
    }

    public List<MenuCommand> getMenuCommandList() {
        return this.menuCommandList;
    }

    public void setMenuCommandList(List<MenuCommand> menuCommandList) {
        this.menuCommandList = menuCommandList;
    }

    public MenuConfig getParent() {
        return this.parent;
    }

    public void setParent(MenuConfig parent) {
        this.parent = parent;
    }

    public MenuConfig getMatchMenuConfig(String command) {
        if (this.menuConfigList != null) {
            for (MenuConfig menuConfig : this.menuConfigList) {
                if (!menuConfig.match(command)) continue;
                return menuConfig;
            }
        }
        return null;
    }

    public MenuCommand getMatchMenuCommand(String command) {
        if (this.menuCommandList != null) {
            for (MenuCommand menuCommand : this.menuCommandList) {
                if (!menuCommand.match(command)) continue;
                return menuCommand;
            }
        }
        return null;
    }

    public String getMenuConfigPath() {
        MenuConfig config = this;
        String showpath = config.getTitle();
        while (config.getParent() != null) {
            config = config.getParent();
            showpath = config.getTitle() + "/" + showpath;
        }
        return showpath;
    }

    public MenuCommand matchEvent(String eventType) {
        if (eventType == null) {
            return null;
        }
        if (this.menuCommandList != null) {
            for (MenuCommand menuCommand : this.menuCommandList) {
                if (!eventType.equals(menuCommand.getEventType())) continue;
                return menuCommand;
            }
        }
        return null;
    }
}

