/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.menucommand.handler;

import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.context.Context;
import org.tinygroup.menucommand.CommandHandler;
import org.tinygroup.menucommand.MenuCommandConstants;
import org.tinygroup.menucommand.config.MenuCommand;
import org.tinygroup.menucommand.config.MenuConfig;
import org.tinygroup.menucommand.config.SystemCommand;
import org.tinygroup.menucommand.handler.MenuCommandHandler;

public abstract class SystemCommandHandler
implements CommandHandler {
    @Override
    public void beforeExecute(Context context) {
        MenuConfig config = (MenuConfig)context.get("menuConfig");
        SystemCommand systemCommand = (SystemCommand)context.get("_system_command");
        String command = (String)context.get("_user_input_command");
        this.execute(command, systemCommand, config, context);
    }

    @Override
    public void afterExecute(Context context) {
        context.remove("menuConfig");
        context.remove("_goto_menu_id");
        context.remove("_render_page_path");
        context.remove("_system_command");
        context.remove("_user_input_command");
    }

    protected String getRenderPath(SystemCommand systemCommand, Context context) {
        return StringUtil.isEmpty((String)systemCommand.getPath()) ? MenuCommandConstants.getRenderPath(context) : systemCommand.getPath();
    }

    protected void dealExitEvent(String command, MenuConfig config, Context context) {
        MenuCommandHandler handler;
        MenuCommand menuCommand = config.matchEvent("exit");
        if (menuCommand != null && (handler = (MenuCommandHandler)menuCommand.createCommandObject()) != null) {
            handler.execute(command, menuCommand, context);
        }
    }

    protected abstract void execute(String var1, SystemCommand var2, MenuConfig var3, Context var4);
}

