/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.pageflowbasiccomponent;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import org.tinygroup.beancontainer.BeanContainer;
import org.tinygroup.beancontainer.BeanContainerFactory;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.context.Context;
import org.tinygroup.fileresolver.FullContextFileRepository;
import org.tinygroup.flow.ComponentInterface;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.template.TemplateContext;
import org.tinygroup.template.TemplateEngine;
import org.tinygroup.template.impl.TemplateContextDefault;
import org.tinygroup.template.impl.TemplateEngineDefault;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.weblayer.WebContext;

public class FullContextUrlRedirect
implements ComponentInterface {
    private static final Logger logger = LoggerFactory.getLogger(FullContextUrlRedirect.class);
    private String path;
    private static final String PAGELET_EXT_FILE_NAME = ".pagelet";
    private static final String PAGE_EXT_FILE_NAME = ".page";
    private String templeteWithLayout = ".page";
    private String template = ".pagelet";
    private FullContextFileRepository fullContextFileRepository;
    private TemplateEngine engine;

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void init() {
        BeanContainer container = BeanContainerFactory.getBeanContainer((ClassLoader)this.getClass().getClassLoader());
        this.fullContextFileRepository = (FullContextFileRepository)container.getBean("fullContextFileRepository");
        this.engine = new TemplateEngineDefault();
        this.templeteWithLayout = StringUtil.defaultIfBlank((String)this.templeteWithLayout, (String)PAGE_EXT_FILE_NAME);
        this.template = StringUtil.defaultIfBlank((String)this.template, (String)PAGELET_EXT_FILE_NAME);
    }

    public void doExecute(Context context) throws FileNotFoundException, IOException, Exception {
        boolean isPagelet = false;
        if (this.path.endsWith(this.template)) {
            isPagelet = true;
            this.path = this.path.substring(0, this.path.length() - this.template.length()) + this.templeteWithLayout;
        }
        FileObject fileObject = this.fullContextFileRepository.getFileObject(this.path);
        WebContext webContent = null;
        if (!(context instanceof WebContext)) {
            return;
        }
        webContent = (WebContext)context;
        if (fileObject != null && fileObject.isExist()) {
            TemplateContextDefault templateContext = new TemplateContextDefault(context.getItemMap());
            if (isPagelet) {
                this.engine.renderTemplateWithOutLayout(this.path, (TemplateContext)templateContext, (Writer)webContent.getResponse().getWriter());
            } else {
                this.engine.renderTemplate(this.path, (TemplateContext)templateContext, (Writer)webContent.getResponse().getWriter());
            }
            return;
        }
        webContent.getResponse().sendError(404);
    }

    public void execute(Context context) {
        try {
            this.init();
            this.doExecute(context);
        }
        catch (Exception e) {
            logger.errorMessage("\u9875\u9762\u8df3\u8f6c\u51fa\u9519", (Throwable)e);
        }
    }
}

