/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.pageflowbasiccomponent;

import org.tinygroup.commons.tools.Assert;
import org.tinygroup.commons.tools.ObjectUtil;
import org.tinygroup.context.Context;
import org.tinygroup.flow.ComponentInterface;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.weblayer.WebContext;

public class SessionOperate
implements ComponentInterface {
    private static final Logger logger = LoggerFactory.getLogger(SessionOperate.class);
    private String sessionKey;
    private String contextKey;

    public String getSessionKey() {
        return this.sessionKey;
    }

    public void setSessionKey(String sessionKey) {
        this.sessionKey = sessionKey;
    }

    public String getContextKey() {
        return this.contextKey;
    }

    public void setContextKey(String contextKey) {
        this.contextKey = contextKey;
    }

    public void execute(Context context) {
        Assert.assertNotNull((Object)this.contextKey, (String)"contextKey must not null", (Object[])new Object[0]);
        Assert.assertNotNull((Object)this.sessionKey, (String)"sessionKey must not null", (Object[])new Object[0]);
        Object object = context.get(this.contextKey);
        if (!ObjectUtil.isEmptyObject((Object)object)) {
            WebContext webContext = (WebContext)context;
            logger.logMessage(LogLevel.INFO, "put object:[{}] to session,the key is [{}]", new Object[]{object, this.sessionKey});
            webContext.getRequest().getSession(true).setAttribute(this.sessionKey, object);
        } else {
            logger.logMessage(LogLevel.WARN, "not found object with key:[{}] from context", new Object[]{this.contextKey});
        }
    }
}

