/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.parser.filter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tinygroup.parser.Node;
import org.tinygroup.parser.NodeFilter;

public abstract class AbstractFilterImpl<T extends Node<T>>
implements NodeFilter<T> {
    private Map<String, String> includeAttributeWithValue = null;
    private Map<String, String> excludeAttributeWithValue = null;
    private String[] includeAttribute = null;
    private String[] excludeAttribute = null;
    private String[] includeText = null;
    private String[] excludeText = null;
    private String[] includeNode = null;
    private String[] excludeNode = null;
    private String[] includeByNode = null;
    private String[] excludeByNode = null;
    private String[] xorSubNode = null;
    private String[] xorProperties = null;
    private T node = null;
    private String nodeName;

    public AbstractFilterImpl() {
    }

    public AbstractFilterImpl(T node) {
        this.init(node);
    }

    public T getNode() {
        return this.node;
    }

    @Override
    public void init(T node) {
        this.node = node;
    }

    @Override
    public NodeFilter setXorSubNode(String ... xorSubNode) {
        this.xorSubNode = xorSubNode;
        return this;
    }

    @Override
    public NodeFilter setXorProperties(String ... xorProperties) {
        this.xorProperties = xorProperties;
        return this;
    }

    protected boolean isRightNode(T node) {
        List list;
        String string;
        if (this.xorSubNode != null && !this.checkXorSubNode(node)) {
            return false;
        }
        if (this.xorProperties != null && !this.checkXorProperties(node)) {
            return false;
        }
        if (this.includeText != null) {
            String string2 = node.getContent();
            if (string2 == null) {
                return false;
            }
            for (String str : this.includeText) {
                if (string2.indexOf(str) >= 0) continue;
                return false;
            }
        }
        if (this.excludeText != null && (string = node.getContent()) != null) {
            for (String str : this.excludeText) {
                if (string.indexOf(str) < 0) continue;
                return false;
            }
        }
        if (this.includeAttributeWithValue != null) {
            for (String key : this.includeAttributeWithValue.keySet()) {
                String value = node.getAttribute(key);
                if (value != null && value.equals(this.includeAttributeWithValue.get(key))) continue;
                return false;
            }
        }
        if (this.excludeAttributeWithValue != null) {
            for (String key : this.excludeAttributeWithValue.keySet()) {
                String value = node.getAttribute(key);
                if (value == null || !value.equals(this.excludeAttributeWithValue.get(key))) continue;
                return false;
            }
        }
        if (this.includeAttribute != null) {
            String[] stringArray = this.includeAttribute;
            int n = stringArray.length;
            for (int value = 0; value < n; ++value) {
                String key = stringArray[value];
                if (node.getAttribute(key) != null) continue;
                return false;
            }
        }
        if (this.excludeAttribute != null) {
            for (String key : this.excludeAttribute) {
                if (node.getAttribute(key) == null) continue;
                return false;
            }
        }
        if (this.includeByNode != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            this.ancestorNodeNames(node, arrayList);
            for (String ancNodeName : arrayList) {
                String[] stringArray = this.includeByNode;
                int str = stringArray.length;
                for (int i = 0; i < str; ++i) {
                    String inByName = stringArray[i];
                    if (node.getCaseSensitiveName(ancNodeName).equals(node.getCaseSensitiveName(inByName))) continue;
                    return false;
                }
            }
        }
        if (this.excludeByNode != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            this.ancestorNodeNames(node, arrayList);
            for (String ancNodeName : arrayList) {
                for (String inByName : this.excludeByNode) {
                    if (!node.getCaseSensitiveName(ancNodeName).equals(node.getCaseSensitiveName(inByName))) continue;
                    return false;
                }
            }
        }
        if (this.includeNode != null) {
            List list2 = node.getSubNodes();
            if (list2 == null || list2.size() == 0) {
                return false;
            }
            for (String inName : this.includeNode) {
                if (this.existNode(list2, inName)) continue;
                return false;
            }
        }
        if (this.excludeNode != null && (list = node.getSubNodes()) != null && list.size() > 0) {
            for (String inName : this.excludeNode) {
                if (!this.existNode(list, inName)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkXorProperties(T node) {
        boolean r = false;
        for (String nodeName : this.xorProperties) {
            if (!node.getNodeType().isHasHeader() || node.getAttribute(nodeName) == null) continue;
            r = true;
            break;
        }
        return r;
    }

    private boolean checkXorSubNode(T node) {
        boolean r = false;
        for (String nodeName : this.xorSubNode) {
            if (nodeName.trim().length() == 0 || node.getSubNodes(nodeName) == null) continue;
            r = true;
            break;
        }
        return r;
    }

    private boolean existNode(List<T> nodes, String nodeName) {
        for (Node node : nodes) {
            if (node.getNodeName() == null || !node.getCaseSensitiveName(nodeName).equals(node.getCaseSensitiveName(node.getNodeName()))) continue;
            return true;
        }
        return false;
    }

    private void ancestorNodeNames(T node, List<String> list) {
        Object parent = node.getParent();
        if (parent != null) {
            if (parent.getNodeName() != null) {
                list.add(parent.getNodeName());
            }
            this.ancestorNodeNames(parent, list);
        }
    }

    protected List<T> filteNode(List<T> nodeWithPath) {
        ArrayList<Node> result = new ArrayList<Node>();
        for (Node tNode : nodeWithPath) {
            if (!this.isRightNode(tNode)) continue;
            result.add(tNode);
        }
        return result;
    }

    @Override
    public NodeFilter setIncludeAttribute(Map<String, String> includeAttribute) {
        if (this.includeAttributeWithValue == null) {
            this.includeAttributeWithValue = includeAttribute;
        } else {
            this.includeAttributeWithValue.putAll(includeAttribute);
        }
        return this;
    }

    @Override
    public NodeFilter setIncludeAttribute(String key, String value) {
        if (this.includeAttributeWithValue == null) {
            this.includeAttributeWithValue = new HashMap<String, String>();
        }
        this.includeAttributeWithValue.put(key, value);
        return this;
    }

    @Override
    public NodeFilter setExcludeAttribute(Map<String, String> excludeAttribute) {
        if (this.excludeAttributeWithValue == null) {
            this.excludeAttributeWithValue = excludeAttribute;
        } else {
            this.excludeAttributeWithValue.putAll(excludeAttribute);
        }
        return this;
    }

    @Override
    public NodeFilter setIncludeText(String ... includeText) {
        this.includeText = includeText;
        return this;
    }

    @Override
    public NodeFilter setExcludeText(String ... excludeText) {
        this.excludeText = excludeText;
        return this;
    }

    @Override
    public NodeFilter setIncludeNode(String ... includeNode) {
        this.includeNode = includeNode;
        return this;
    }

    @Override
    public NodeFilter setExcludeNode(String ... excludeNode) {
        this.excludeNode = excludeNode;
        return this;
    }

    @Override
    public NodeFilter setIncludeByNode(String ... includeByNode) {
        this.includeByNode = includeByNode;
        return this;
    }

    @Override
    public NodeFilter setExcludeByNode(String ... excludeByNode) {
        this.excludeByNode = excludeByNode;
        return this;
    }

    @Override
    public NodeFilter clearCondition() {
        this.includeAttributeWithValue = null;
        this.excludeAttributeWithValue = null;
        this.includeText = null;
        this.excludeText = null;
        this.includeNode = null;
        this.excludeNode = null;
        this.includeByNode = null;
        this.excludeByNode = null;
        this.includeAttribute = null;
        this.excludeAttribute = null;
        this.xorSubNode = null;
        this.xorProperties = null;
        return this;
    }

    @Override
    public NodeFilter setIncludeAttributes(String ... includeAttribute) {
        this.includeAttribute = includeAttribute;
        return this;
    }

    @Override
    public NodeFilter setExcludeAttribute(String ... excludeAttribute) {
        this.excludeAttribute = excludeAttribute;
        return this;
    }

    @Override
    public T findNode(String nodeName) {
        List result = this.findNodeList(nodeName);
        if (result.size() == 0) {
            return null;
        }
        return (T)((Node)result.get(0));
    }

    @Override
    public NodeFilter setNodeName(String nodeName) {
        this.nodeName = nodeName;
        return this;
    }

    @Override
    public T findNode() {
        return this.findNode(this.nodeName);
    }

    @Override
    public List<T> findNodeList() {
        return this.findNodeList(this.nodeName);
    }

    class NodeList
    implements Comparable<NodeList> {
        private boolean caseSensitive;
        private String nodeName;
        private List<T> nodeList = new ArrayList();

        public NodeList(boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
        }

        NodeList(String nodeName) {
            this.nodeName = nodeName;
        }

        public List<T> getNodeList() {
            return this.nodeList;
        }

        @Override
        public int compareTo(NodeList o) {
            if (!this.caseSensitive) {
                return this.nodeName.toLowerCase().compareTo(o.nodeName.toLowerCase());
            }
            return this.nodeName.compareTo(o.nodeName);
        }
    }
}

