/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.parser.filter;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tinygroup.parser.Node;
import org.tinygroup.parser.filter.AbstractFilterImpl;

public class PathFilter<T extends Node<T>>
extends AbstractFilterImpl<T> {
    public PathFilter() {
    }

    public PathFilter(T node) {
        super(node);
    }

    private List<String> splitPath(String path) {
        ArrayList<String> v = new ArrayList<String>();
        Pattern pattern = Pattern.compile("/[^/]*");
        Matcher matcher = pattern.matcher(path);
        int pos = 0;
        while (matcher.find()) {
            if (pos < matcher.start()) {
                v.add(path.substring(pos, matcher.start()));
                pos = matcher.start();
            }
            v.add(path.substring(pos, matcher.end()));
            pos = matcher.end();
        }
        if (pos < path.length()) {
            v.add(path.substring(pos));
        }
        return v;
    }

    private void locateNode(List<T> nodeWithPath, T node, List<String> paths, int index) {
        block5: {
            List nv;
            String path;
            block4: {
                path = paths.get(index);
                if (index != paths.size() - 1) break block4;
                if (node.getNodeName() != null && node.getNodeName().equals(node.getCaseSensitiveName(path.substring(1)))) {
                    nodeWithPath.add(node);
                } else {
                    for (Node subNode : node.getSubNodes()) {
                        this.locateNode(nodeWithPath, subNode, paths, index);
                    }
                }
                break block5;
            }
            if (node.getNodeName() == null || !node.getNodeName().equals(node.getCaseSensitiveName(path.substring(1))) || (nv = node.getSubNodes()) == null) break block5;
            for (Node n : nv) {
                if (n.getNodeName() == null) continue;
                this.locateNode(nodeWithPath, n, paths, index + 1);
            }
        }
    }

    @Override
    public T findNode(String path) {
        List result = new ArrayList();
        if (this.getNode() != null && path != null) {
            Object currentNode = this.getNode();
            int index = 0;
            List<String> paths = this.splitPath(path);
            if (paths.get(0).startsWith("/")) {
                if (this.getNode().getRoot() != currentNode) {
                    currentNode = currentNode.getRoot();
                }
            } else {
                String p = paths.get(index);
                while (p.equals("..") || p.equals("/..")) {
                    currentNode = currentNode.getParent();
                    p = paths.get(++index);
                }
            }
            ArrayList nodeWithPath = new ArrayList();
            this.locateNode(nodeWithPath, currentNode, paths, index);
            result = this.filteNode(nodeWithPath);
        }
        if (result.size() >= 1) {
            return (T)((Node)result.get(0));
        }
        return null;
    }

    @Override
    public List<T> findNodeList(String path) {
        List result = new ArrayList();
        if (path != null) {
            Object currentNode = this.getNode();
            int index = 0;
            List<String> paths = this.splitPath(path);
            if (paths.get(0).startsWith("/")) {
                if (this.getNode().getRoot() != currentNode) {
                    currentNode = currentNode.getRoot();
                }
            } else {
                String p = paths.get(index);
                while (p.equals("..") || p.equals("/..")) {
                    currentNode = currentNode.getParent();
                    p = paths.get(++index);
                }
            }
            ArrayList nodeWithPath = new ArrayList();
            this.locateNode(nodeWithPath, currentNode, paths, index);
            result = this.filteNode(nodeWithPath);
        }
        return result;
    }
}

