/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.queue.impl;

import org.tinygroup.commons.exceptions.NotExistException;
import org.tinygroup.queue.Queue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueueImpl<E>
implements Queue<E> {
    private int maxSize;
    private E[] queueArray;
    private int offerPosition = 0;
    private int size = 0;
    private int pollPosition = 0;
    private String name;

    public QueueImpl() {
        this(500);
    }

    public QueueImpl(String name) {
        this(name, 500);
    }

    public QueueImpl(String name, int size) {
        this.name = name;
        this.maxSize = size;
        this.queueArray = new Object[size];
    }

    public QueueImpl(int size) {
        this(null, size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void offer(E o) {
        E[] EArray = this.queueArray;
        synchronized (this.queueArray) {
            if (this.size >= this.maxSize) {
                throw new RuntimeException("\u4f18\u5148\u961f\u5217\u5df2\u6ee1\uff01");
            }
            this.queueArray[this.offerPosition++] = o;
            if (this.offerPosition == this.maxSize) {
                this.offerPosition = 0;
            }
            ++this.size;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll() {
        E[] EArray = this.queueArray;
        synchronized (this.queueArray) {
            if (this.size == 0) {
                throw new RuntimeException("\u961f\u5217\u4e3a\u7a7a\uff01");
            }
            E e = this.queueArray[this.pollPosition];
            this.queueArray[this.pollPosition] = null;
            ++this.pollPosition;
            if (this.pollPosition == this.maxSize) {
                this.pollPosition = 0;
            }
            --this.size;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E remove() {
        E[] EArray = this.queueArray;
        synchronized (this.queueArray) {
            if (this.size == 0) {
                throw new NotExistException();
            }
            E e = this.queueArray[this.pollPosition];
            this.queueArray[this.pollPosition] = null;
            ++this.pollPosition;
            if (this.pollPosition == this.maxSize) {
                this.pollPosition = 0;
            }
            --this.size;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E peek() {
        E[] EArray = this.queueArray;
        synchronized (this.queueArray) {
            if (this.maxSize == 0) {
                throw new RuntimeException("\u961f\u5217\u4e3a\u7a7a\uff01");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.queueArray[this.pollPosition];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E element() {
        E[] EArray = this.queueArray;
        synchronized (this.queueArray) {
            if (this.isEmpty()) {
                throw new NotExistException();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.queueArray[this.pollPosition];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        E[] EArray = this.queueArray;
        synchronized (this.queueArray) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.size == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFull() {
        E[] EArray = this.queueArray;
        synchronized (this.queueArray) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.size == this.maxSize;
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return this.getClass().getSimpleName();
    }

    @Override
    public int getSize() {
        return this.maxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUsingSize() {
        E[] EArray = this.queueArray;
        synchronized (this.queueArray) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getIdleSize() {
        E[] EArray = this.queueArray;
        synchronized (this.queueArray) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.maxSize - this.size;
        }
    }

    @Override
    public int size() {
        return this.size;
    }
}

