/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.serviceprocessor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.tinygroup.cepcore.CEPCore;
import org.tinygroup.cepcore.impl.AbstractEventProcessor;
import org.tinygroup.context.Context;
import org.tinygroup.context.util.ContextFactory;
import org.tinygroup.event.Event;
import org.tinygroup.event.Parameter;
import org.tinygroup.event.ServiceInfo;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.service.Service;
import org.tinygroup.service.ServiceProviderInterface;
import org.tinygroup.service.registry.ServiceRegistryItem;

public class ServiceEventProcessorImpl
extends AbstractEventProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceEventProcessorImpl.class);
    private ServiceProviderInterface provider;
    private List<ServiceInfo> infos = new ArrayList<ServiceInfo>();

    public void process(Event event) {
        String serviceId = event.getServiceRequest().getServiceId();
        Service service = this.provider.getService(serviceId);
        if (service != null) {
            this.provider.execute(service, event.getServiceRequest().getContext());
            ServiceRegistryItem item = this.provider.getServiceRegistryItem(service);
            Context oldC = event.getServiceRequest().getContext();
            Context c = ContextFactory.getContext();
            for (Parameter p : item.getResults()) {
                if ("void".equals(p.getType()) || "".equals(p.getType()) || p.getType() == null) continue;
                String name = p.getName();
                c.put(name, oldC.get(name));
            }
            event.getServiceRequest().setContext(c);
        } else {
            LOGGER.logMessage(LogLevel.ERROR, "\u672a\u627e\u5230\u5408\u9002\u7684Service[id:{0}]", new Object[]{serviceId});
        }
    }

    public void setCepCore(CEPCore cepCore) {
    }

    public void setServiceProvider(ServiceProviderInterface provider) {
        this.provider = provider;
    }

    public List<ServiceInfo> getServiceInfos() {
        if (!this.isRead()) {
            this.infos.clear();
            Collection collection = this.provider.getServiceRegistory().getServiceRegistryItems();
            if (collection != null) {
                for (ServiceRegistryItem item : collection) {
                    if (this.infos.contains(item)) continue;
                    this.infos.add((ServiceInfo)item);
                }
            }
        }
        return this.infos;
    }

    public int getWeight() {
        return 0;
    }

    public List<String> getRegex() {
        return null;
    }

    public boolean isRead() {
        return !this.provider.getServiceRegistory().isChange();
    }

    public void setRead(boolean read) {
        this.provider.getServiceRegistory().setChange(!read);
    }
}

