/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.sqlindexsource.impl;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.tinygroup.beancontainer.BeanContainerFactory;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.context.Context;
import org.tinygroup.context.impl.ContextImpl;
import org.tinygroup.fulltext.document.Document;
import org.tinygroup.fulltext.exception.FullTextException;
import org.tinygroup.sqlindexsource.config.SqlConfig;
import org.tinygroup.sqlindexsource.config.SqlConfigs;
import org.tinygroup.sqlindexsource.impl.AbstractResultSetOperator;
import org.tinygroup.templateindex.TemplateIndexOperator;
import org.tinygroup.templateindex.impl.DynamicDocumentCreator;

public class SqlConfigsIndexOperator
extends AbstractResultSetOperator
implements TemplateIndexOperator<SqlConfigs> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Document> createDocuments(SqlConfigs config) throws Exception {
        ArrayList<Document> documents = new ArrayList<Document>();
        Connection conn = this.getConnection(config);
        try {
            if (config.getSqlConfigList() != null) {
                for (SqlConfig sqlConfig : config.getSqlConfigList()) {
                    this.dealSqlConfig(conn, sqlConfig, documents);
                }
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        return documents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dealSqlConfig(Connection conn, SqlConfig sqlConfig, List<Document> documents) throws Exception {
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            ResultSet data = stmt.executeQuery(sqlConfig.getStatement());
            ResultSetMetaData rsmd = data.getMetaData();
            while (data.next()) {
                ContextImpl context = new ContextImpl();
                for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                    String name = rsmd.getColumnName(i);
                    this.updateContext(data, i, name, (Context)context);
                }
                DynamicDocumentCreator creator = new DynamicDocumentCreator(sqlConfig.getFieldConfigList());
                Document doc = creator.execute((Context)context);
                documents.add(doc);
            }
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    private Connection getConnection(SqlConfigs config) {
        if (!StringUtil.isEmpty((String)config.getDataSourceBean())) {
            try {
                DataSource dataSource = (DataSource)BeanContainerFactory.getBeanContainer((ClassLoader)this.getClass().getClassLoader()).getBean(config.getDataSourceBean());
                return dataSource.getConnection();
            }
            catch (Exception e) {
                throw new FullTextException(String.format("\u52a0\u8f7dbean\u914d\u7f6e[%s]\u53d1\u751f\u5f02\u5e38", config.getDataSourceBean()), (Throwable)e);
            }
        }
        try {
            Class.forName(config.getDriver());
        }
        catch (Exception e) {
            throw new FullTextException(String.format("\u52a0\u8f7d\u9a71\u52a8\u7c7b[%s]\u53d1\u751f\u5f02\u5e38", config.getDriver()), (Throwable)e);
        }
        try {
            return DriverManager.getConnection(config.getUrl(), config.getUser(), config.getPassword());
        }
        catch (Exception e) {
            throw new FullTextException(String.format("DriverManager\u52a0\u8f7dConnection\u5931\u8d25:\u6570\u636e\u5e93\u5730\u5740[%s],\u7528\u6237\u540d[%s],\u5bc6\u7801[%s]", config.getUrl(), config.getUser(), config.getPassword()), (Throwable)e);
        }
    }
}

