/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.sqlindexsource.impl;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Date;
import org.tinygroup.context.Context;

public abstract class AbstractResultSetOperator {
    public void updateContext(ResultSet data, int i, String name, Context context) throws SQLException {
        ResultSetMetaData rsmd = data.getMetaData();
        int type = rsmd.getColumnType(i);
        if (this.isString(type)) {
            context.put(name, (Object)data.getString(i));
        } else if (this.isInt(type)) {
            context.put(name, (Object)data.getInt(i));
        } else if (this.isLong(type)) {
            context.put(name, (Object)data.getLong(i));
        } else if (this.isFloat(type)) {
            context.put(name, (Object)Float.valueOf(data.getFloat(i)));
        } else if (this.isDouble(type)) {
            context.put(name, (Object)data.getDouble(i));
        } else if (this.isBigDecimal(type)) {
            context.put(name, (Object)data.getBigDecimal(i));
        } else if (this.isDate(type)) {
            this.updateDate(type, data, i, name, context);
        } else if (this.isByte(type)) {
            context.put(name, (Object)data.getBytes(i));
        } else {
            context.put(name, data.getObject(i));
        }
    }

    private void updateDate(int type, ResultSet data, int i, String name, Context context) throws SQLException {
        if (type == 91) {
            if (data.getDate(i) != null) {
                context.put(name, (Object)new Date(data.getDate(i).getTime()));
            }
        } else if (type == 92) {
            if (data.getTime(i) != null) {
                context.put(name, (Object)new Date(data.getTime(i).getTime()));
            }
        } else if (data.getTimestamp(i) != null) {
            context.put(name, (Object)new Date(data.getTimestamp(i).getTime()));
        }
    }

    private boolean isString(int type) {
        return type == 1 || type == 12 || type == -1;
    }

    private boolean isByte(int type) {
        return type == -2 || type == -3 || type == -4;
    }

    private boolean isInt(int type) {
        return type == -7 || type == 16 || type == 5 || type == -6 || type == 4;
    }

    private boolean isLong(int type) {
        return type == -5;
    }

    private boolean isFloat(int type) {
        return type == 7 || type == 6;
    }

    private boolean isDouble(int type) {
        return type == 8;
    }

    private boolean isBigDecimal(int type) {
        return type == 3 || type == 2;
    }

    private boolean isDate(int type) {
        return type == 91 || type == 92 || type == 93;
    }
}

