/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.database;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.tinygroup.tinyscript.dataset.AbstractDataSet;
import org.tinygroup.tinyscript.dataset.Field;

public class ResultSetDataSet
extends AbstractDataSet {
    private final ResultSet resultSet;
    private int columnCount;

    public ResultSetDataSet(ResultSet resultSet) {
        this.resultSet = resultSet;
        try {
            ResultSetMetaData metaData = resultSet.getMetaData();
            this.columnCount = metaData.getColumnCount();
            for (int i = 1; i <= this.columnCount; ++i) {
                Field field = new Field();
                field.setName(metaData.getColumnLabel(i));
                field.setTitle(metaData.getColumnLabel(i));
                field.setType(metaData.getColumnClassName(i));
                this.fields.add(field);
            }
            this.setFields(this.fields);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public ResultSetDataSet(ResultSet resultSet, boolean tag) {
        this(resultSet);
        this.setIndexFromOne(tag);
    }

    public boolean isReadOnly() {
        try {
            return this.resultSet.getConcurrency() == 1007;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void checkNoForwardType() throws Exception {
        try {
            if (this.resultSet.getType() == 1003) {
                throw new Exception("\u7ed3\u679c\u96c6\u53ea\u652f\u6301\u5411\u524d\u6eda\u52a8");
            }
        }
        catch (SQLException e) {
            throw new Exception(e);
        }
    }

    public void first() throws Exception {
        this.checkNoForwardType();
        try {
            this.resultSet.first();
        }
        catch (SQLException e) {
            throw new Exception(e);
        }
    }

    public boolean previous() throws Exception {
        this.checkNoForwardType();
        try {
            return this.resultSet.previous();
        }
        catch (SQLException e) {
            throw new Exception(e);
        }
    }

    public void beforeFirst() throws Exception {
        this.checkNoForwardType();
        try {
            this.resultSet.beforeFirst();
        }
        catch (SQLException e) {
            throw new Exception(e);
        }
    }

    public void afterLast() throws Exception {
        this.checkNoForwardType();
        try {
            this.resultSet.afterLast();
        }
        catch (SQLException e) {
            throw new Exception(e);
        }
    }

    public boolean next() throws Exception {
        try {
            return this.resultSet.next();
        }
        catch (SQLException e) {
            throw new Exception(e);
        }
    }

    public boolean absolute(int row) throws Exception {
        this.checkNoForwardType();
        try {
            if (this.isIndexFromOne()) {
                return this.resultSet.absolute(row);
            }
            return this.resultSet.absolute(row + 1);
        }
        catch (SQLException e) {
            throw new Exception(e);
        }
    }

    public int getRows() throws Exception {
        throw new Exception("\u4e0d\u652f\u6301\u7684\u65b9\u6cd5\uff01");
    }

    public int getColumns() throws Exception {
        return this.columnCount;
    }

    public <T> T getData(int row, int col) throws Exception {
        if (this.absolute(row)) {
            return this.getData(col);
        }
        throw new Exception("\u4e0d\u5b58\u5728" + row + "\u884c\u7684\u6570\u636e\uff01");
    }

    public <T> void setData(int row, int col, T data) throws Exception {
        this.throwNotSupportMethod();
    }

    public <T> T getData(int col) throws Exception {
        try {
            if (this.isIndexFromOne()) {
                return (T)this.resultSet.getObject(col);
            }
            return (T)this.resultSet.getObject(col + 1);
        }
        catch (SQLException e) {
            throw new Exception(e);
        }
    }

    public <T> void setData(int col, T data) throws Exception {
        this.throwNotSupportMethod();
    }

    public <T> void setData(String filedName, T data) throws Exception {
        this.throwNotSupportMethod();
    }

    public void clean() {
        super.clean();
        try {
            this.resultSet.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

