/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.database.function;

import java.sql.Connection;
import java.sql.Statement;
import javax.sql.DataSource;
import org.tinygroup.tinyscript.ScriptContext;
import org.tinygroup.tinyscript.ScriptException;
import org.tinygroup.tinyscript.ScriptSegment;
import org.tinygroup.tinyscript.function.AbstractScriptFunction;

public class ExecuteSqlFunction
extends AbstractScriptFunction {
    public String getNames() {
        return "execute";
    }

    public String getBindingTypes() {
        return "javax.sql.DataSource,java.sql.Connection";
    }

    public Object execute(ScriptSegment segment, ScriptContext context, Object ... parameters) throws ScriptException {
        try {
            if (parameters == null || parameters.length == 0) {
                throw new ScriptException("execute\u51fd\u6570\u7684\u53c2\u6570\u4e3a\u7a7a!");
            }
            if (parameters.length == 2 && parameters[0] != null && parameters[1] != null) {
                String sql = (String)parameters[1];
                if (parameters[0] instanceof DataSource) {
                    return this.executeDataSource((DataSource)parameters[0], sql);
                }
                if (parameters[0] instanceof Connection) {
                    return this.executeConnection((Connection)parameters[0], sql);
                }
                throw new ScriptException("execute\u51fd\u6570\u7684\u53c2\u6570\u683c\u5f0f\u4e0d\u6b63\u786e:\u672a\u77e5\u7c7b\u578b" + parameters[0].getClass().getName());
            }
            throw new ScriptException("execute\u51fd\u6570\u7684\u53c2\u6570\u683c\u5f0f\u4e0d\u6b63\u786e!");
        }
        catch (ScriptException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ScriptException("execute\u51fd\u6570\u6267\u884c\u53d1\u751f\u5f02\u5e38:", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeDataSource(DataSource dataSource, String sql) throws Exception {
        Connection conn = null;
        Statement statement = null;
        try {
            conn = dataSource.getConnection();
            statement = conn.createStatement();
            int n = statement.executeUpdate(sql);
            return n;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeConnection(Connection conn, String sql) throws Exception {
        Statement statement = null;
        try {
            statement = conn.createStatement();
            int n = statement.executeUpdate(sql);
            return n;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
    }
}

