/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.database;

import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.jdbc.support.rowset.SqlRowSetMetaData;
import org.tinygroup.tinyscript.dataset.AbstractDataSet;
import org.tinygroup.tinyscript.dataset.Field;
import org.tinygroup.tinyscript.interpret.ResourceBundleUtil;

public class SqlRowSetDataSet
extends AbstractDataSet {
    private SqlRowSet sqlRowSet;
    private int columnCount;

    public SqlRowSetDataSet(SqlRowSet sqlRowSet) {
        this.sqlRowSet = sqlRowSet;
        try {
            SqlRowSetMetaData metaData = sqlRowSet.getMetaData();
            this.columnCount = metaData.getColumnCount();
            for (int i = 1; i <= this.columnCount; ++i) {
                Field field = new Field();
                field.setName(metaData.getColumnLabel(i));
                field.setTitle(metaData.getColumnLabel(i));
                field.setType(metaData.getColumnClassName(i));
                this.fields.add(field);
            }
            this.setFields(this.fields);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public SqlRowSetDataSet(SqlRowSet sqlRowSet, boolean tag) {
        this(sqlRowSet);
        this.setIndexFromOne(tag);
    }

    public SqlRowSet getSqlRowSet() {
        return this.sqlRowSet;
    }

    public boolean isReadOnly() {
        return true;
    }

    public void first() throws Exception {
        this.sqlRowSet.first();
    }

    public boolean previous() throws Exception {
        return this.sqlRowSet.previous();
    }

    public void beforeFirst() throws Exception {
        this.sqlRowSet.beforeFirst();
    }

    public void afterLast() throws Exception {
        this.sqlRowSet.afterLast();
    }

    public boolean next() throws Exception {
        return this.sqlRowSet.next();
    }

    public boolean absolute(int row) throws Exception {
        return this.sqlRowSet.absolute(row);
    }

    public int getRows() throws Exception {
        this.throwNotSupportMethod();
        return 0;
    }

    public int getColumns() throws Exception {
        return this.sqlRowSet.getMetaData().getColumnCount();
    }

    public <T> T getData(int row, int col) throws Exception {
        if (this.absolute(row)) {
            return this.getData(col);
        }
        throw new Exception(ResourceBundleUtil.getResourceMessage((String)"database", (String)"database.data.noexists", (Object[])new Object[]{row}));
    }

    public <T> void setData(int row, int col, T data) throws Exception {
        this.throwNotSupportMethod();
    }

    public <T> T getData(int col) throws Exception {
        if (this.isIndexFromOne()) {
            return (T)this.sqlRowSet.getObject(col);
        }
        return (T)this.sqlRowSet.getObject(col + 1);
    }

    public <T> void setData(int col, T data) throws Exception {
        this.throwNotSupportMethod();
    }
}

