/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.database.sql;

import javax.sql.DataSource;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.tinygroup.config.util.ConfigurationUtil;
import org.tinygroup.context.Context;
import org.tinygroup.parsedsql.JDBCNamedSqlExecutor;
import org.tinygroup.parsedsql.SQLParser;
import org.tinygroup.parsedsql.base.DatabaseType;
import org.tinygroup.parsedsql.impl.DefaultSQLParser;
import org.tinygroup.parsedsql.impl.SimpleJDBCNamedSqlExecutor;
import org.tinygroup.tinyscript.ScriptContext;
import org.tinygroup.tinyscript.ScriptException;
import org.tinygroup.tinyscript.database.SqlRowSetDataSet;
import org.tinygroup.tinyscript.interpret.ResourceBundleUtil;
import org.tinygroup.tinyscript.interpret.ScriptContextUtil;
import org.tinygroup.tinyscript.interpret.custom.CustomProcessor;

public abstract class AbstractParsedSqlProcessor
implements CustomProcessor {
    private static final String DB_TYPE = "defaultDB";
    protected JDBCNamedSqlExecutor sqlExecutor;
    protected SQLParser sqlParser = new DefaultSQLParser();

    public AbstractParsedSqlProcessor() {
        this.sqlExecutor = new SimpleJDBCNamedSqlExecutor();
        this.sqlExecutor.setSqlParser(this.sqlParser);
    }

    public JDBCNamedSqlExecutor getSqlExecutor() {
        return this.sqlExecutor;
    }

    public void setSqlExecutor(JDBCNamedSqlExecutor sqlExecutor) {
        this.sqlExecutor = sqlExecutor;
    }

    public SQLParser getSqlParser() {
        return this.sqlParser;
    }

    public void setSqlParser(SQLParser sqlParser) {
        this.sqlParser = sqlParser;
    }

    protected boolean isSelect(String sql) {
        String s = sql.trim().toLowerCase();
        return s.startsWith("select");
    }

    protected String parseSql(String sql, ScriptContext context) throws ScriptException {
        String dbType = (String)context.get(DB_TYPE);
        if (dbType == null) {
            dbType = ConfigurationUtil.getConfigurationManager().getConfiguration(DB_TYPE);
        }
        if (dbType == null) {
            throw new ScriptException(ResourceBundleUtil.getResourceMessage((String)"database", (String)"database.type.error", (Object[])new Object[]{DB_TYPE}));
        }
        DatabaseType databaseType = DatabaseType.valueFrom((String)dbType);
        return this.sqlParser.parse(databaseType, sql, (Context)context);
    }

    protected Object executeByDataSource(DataSource dataSource, String sql, ScriptContext context) throws ScriptException {
        String newSql = this.parseSql(sql, context);
        try {
            if (this.isSelect(newSql)) {
                SqlRowSet sqlRowSet = this.sqlExecutor.queryForSqlRowSet(newSql, dataSource, (Context)context);
                return new SqlRowSetDataSet(sqlRowSet, ScriptContextUtil.getScriptEngine((ScriptContext)context).isIndexFromOne());
            }
            return this.sqlExecutor.execute(newSql, dataSource, (Context)context);
        }
        catch (Exception e) {
            throw new ScriptException((Throwable)e);
        }
    }
}

