/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.database.function;

import java.sql.Connection;
import java.sql.Statement;
import javax.sql.DataSource;
import org.tinygroup.tinyscript.ScriptContext;
import org.tinygroup.tinyscript.ScriptException;
import org.tinygroup.tinyscript.ScriptSegment;
import org.tinygroup.tinyscript.function.AbstractScriptFunction;
import org.tinygroup.tinyscript.interpret.ResourceBundleUtil;

public class ExecuteSqlFunction
extends AbstractScriptFunction {
    public String getNames() {
        return "execute";
    }

    public String getBindingTypes() {
        return "javax.sql.DataSource,java.sql.Connection";
    }

    public Object execute(ScriptSegment segment, ScriptContext context, Object ... parameters) throws ScriptException {
        try {
            if (parameters == null || parameters.length == 0) {
                throw new ScriptException(ResourceBundleUtil.getDefaultMessage((String)"function.parameter.empty", (Object[])new Object[]{this.getNames()}));
            }
            if (parameters.length == 2 && parameters[0] != null && parameters[1] != null) {
                String sql = (String)parameters[1];
                if (parameters[0] instanceof DataSource) {
                    return this.executeDataSource((DataSource)parameters[0], sql);
                }
                if (parameters[0] instanceof Connection) {
                    return this.executeConnection((Connection)parameters[0], sql);
                }
                throw new ScriptException(ResourceBundleUtil.getDefaultMessage((String)"function.parameter.error", (Object[])new Object[]{this.getNames()}));
            }
            throw new ScriptException(ResourceBundleUtil.getDefaultMessage((String)"function.parameter.error", (Object[])new Object[]{this.getNames()}));
        }
        catch (ScriptException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ScriptException(ResourceBundleUtil.getDefaultMessage((String)"function.run.error", (Object[])new Object[]{this.getNames()}), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeDataSource(DataSource dataSource, String sql) throws Exception {
        Connection conn = null;
        Statement statement = null;
        try {
            conn = dataSource.getConnection();
            statement = conn.createStatement();
            int n = statement.executeUpdate(sql);
            return n;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeConnection(Connection conn, String sql) throws Exception {
        Statement statement = null;
        try {
            statement = conn.createStatement();
            int n = statement.executeUpdate(sql);
            return n;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
    }
}

