/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.database.function;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.tinygroup.context.Context;
import org.tinygroup.tinyscript.ScriptContext;
import org.tinygroup.tinyscript.ScriptException;
import org.tinygroup.tinyscript.ScriptSegment;
import org.tinygroup.tinyscript.dataset.AbstractDataSet;
import org.tinygroup.tinyscript.dataset.DataSet;
import org.tinygroup.tinyscript.dataset.Field;
import org.tinygroup.tinyscript.function.AbstractScriptFunction;
import org.tinygroup.tinyscript.interpret.ResourceBundleUtil;
import org.tinygroup.tinyscript.interpret.ScriptContextUtil;
import org.tinygroup.tinyscript.interpret.ScriptUtil;

public class WriteDBFunction
extends AbstractScriptFunction {
    private static final int MAX_RECORDS = 200;

    public String getNames() {
        return "writeDB";
    }

    public String getBindingTypes() {
        return DataSet.class.getName();
    }

    public Object execute(ScriptSegment segment, ScriptContext context, Object ... parameters) throws ScriptException {
        try {
            if (parameters == null || parameters.length == 0) {
                throw new ScriptException(ResourceBundleUtil.getDefaultMessage((String)"function.parameter.empty", (Object[])new Object[]{this.getNames()}));
            }
            if (this.checkParameters(parameters, 2)) {
                AbstractDataSet ds = (AbstractDataSet)parameters[0];
                String table = (String)parameters[1];
                return this.insertDataSet(ds, table, null, context);
            }
            if (this.checkParameters(parameters, 3)) {
                AbstractDataSet ds = (AbstractDataSet)parameters[0];
                String table = (String)parameters[1];
                DataSource dataSource = (DataSource)parameters[2];
                return this.insertDataSet(ds, table, dataSource, context);
            }
            throw new ScriptException(ResourceBundleUtil.getDefaultMessage((String)"function.parameter.error", (Object[])new Object[]{this.getNames()}));
        }
        catch (ScriptException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ScriptException(ResourceBundleUtil.getDefaultMessage((String)"function.run.error", (Object[])new Object[]{this.getNames()}), (Throwable)e);
        }
    }

    private Object insertDataSet(AbstractDataSet ds, String table, DataSource dataSource, ScriptContext context) throws Exception {
        DataSource newDataSource = dataSource == null ? (DataSource)ScriptUtil.getVariableValue((Context)context, (Object)ScriptContextUtil.getCustomBeanName((ScriptContext)context)) : dataSource;
        Connection conn = null;
        Statement ps = null;
        String insertSql = null;
        try {
            conn = newDataSource.getConnection();
            ResultSetMetaData rsmd = this.getTableMetaData(table, conn);
            Map<Integer, Integer> maps = this.createMap((DataSet)ds, rsmd);
            insertSql = this.createSQL((DataSet)ds, table);
            conn.setAutoCommit(false);
            ps = conn.prepareStatement(insertSql);
            int count = 0;
            int[] result = new int[ds.getRows()];
            int i = 0;
            int j = 0;
            try {
                for (i = 0; i < ds.getRows(); ++i) {
                    for (j = 0; j < ds.getColumns(); ++j) {
                        int targetSqlType = rsmd.getColumnType(maps.get(j));
                        ps.setObject(j + 1, ds.getData(ds.getShowIndex(i), ds.getShowIndex(j)), targetSqlType);
                    }
                    ps.addBatch();
                    if (++count % 200 != 0) continue;
                    int[] temp = ps.executeBatch();
                    System.arraycopy(temp, 0, result, count - 200, 200);
                }
                int[] temp = ps.executeBatch();
                System.arraycopy(temp, 0, result, result.length - temp.length, temp.length);
                conn.commit();
            }
            catch (Exception e) {
                throw new ScriptException(ResourceBundleUtil.getResourceMessage((String)"database", (String)"database.sql.position.error", (Object[])new Object[]{this.getNames(), insertSql, ds.getShowIndex(i), ds.getShowIndex(j)}), (Throwable)e);
            }
            int[] nArray = result;
            return nArray;
        }
        catch (ScriptException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ScriptException(ResourceBundleUtil.getResourceMessage((String)"database", (String)"database.sql.error", (Object[])new Object[]{this.getNames(), insertSql}), (Throwable)e);
        }
        finally {
            if (ps != null) {
                ps.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    private Map<Integer, Integer> createMap(DataSet ds, ResultSetMetaData rsmd) throws Exception {
        HashMap<String, Integer> maps = new HashMap<String, Integer>();
        HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
        for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
            maps.put(rsmd.getColumnName(i).toUpperCase(), i);
        }
        List fields = ds.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            Field f = (Field)fields.get(i);
            String name = f.getName().toUpperCase();
            if (!maps.containsKey(name)) {
                throw new ScriptException(ResourceBundleUtil.getResourceMessage((String)"database", (String)"database.field.noexists", (Object[])new Object[]{f.getName()}));
            }
            result.put(i, (Integer)maps.get(name));
        }
        return result;
    }

    private String createSQL(DataSet ds, String table) throws Exception {
        List fields = ds.getFields();
        StringBuilder sb = new StringBuilder();
        StringBuilder values = new StringBuilder();
        values.append(" values(");
        sb.append("insert into ").append(table);
        sb.append(" (");
        for (int i = 0; i < fields.size(); ++i) {
            Field f = (Field)fields.get(i);
            if (i == fields.size() - 1) {
                sb.append(f.getName());
                values.append("?");
                continue;
            }
            sb.append(f.getName()).append(",");
            values.append("?,");
        }
        sb.append(")");
        values.append(")");
        sb.append((CharSequence)values);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSetMetaData getTableMetaData(String table, Connection conn) throws Exception {
        String sql = "select * from " + table + " where 1=0; ";
        Statement sc = null;
        ResultSet rs = null;
        try {
            sc = conn.createStatement();
            rs = sc.executeQuery(sql);
            ResultSetMetaData resultSetMetaData = rs.getMetaData();
            return resultSetMetaData;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (sc != null) {
                sc.close();
            }
        }
    }
}

