/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.database.sql;

import java.util.ArrayList;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.tinygroup.context.Context;
import org.tinygroup.parsedsql.JDBCNamedSqlExecutor;
import org.tinygroup.parsedsql.SQLParser;
import org.tinygroup.parsedsql.impl.DefaultSQLParser;
import org.tinygroup.parsedsql.impl.SimpleJDBCNamedSqlExecutor;
import org.tinygroup.tinyscript.ScriptContext;
import org.tinygroup.tinyscript.ScriptException;
import org.tinygroup.tinyscript.database.SqlRowSetDataSet;
import org.tinygroup.tinyscript.expression.ExpressionUtil;
import org.tinygroup.tinyscript.impl.DefaultScriptContext;
import org.tinygroup.tinyscript.interpret.ScriptContextUtil;
import org.tinygroup.tinyscript.interpret.custom.CustomProcessor;

public abstract class AbstractParsedSqlProcessor
implements CustomProcessor {
    private static final String SQL_ALLOW_NULL = "sqlAllowNull";
    protected JDBCNamedSqlExecutor sqlExecutor;
    protected SQLParser sqlParser = new DefaultSQLParser();

    public AbstractParsedSqlProcessor() {
        this.sqlExecutor = new SimpleJDBCNamedSqlExecutor();
        this.sqlExecutor.setSqlParser(this.sqlParser);
    }

    public JDBCNamedSqlExecutor getSqlExecutor() {
        return this.sqlExecutor;
    }

    public void setSqlExecutor(JDBCNamedSqlExecutor sqlExecutor) {
        this.sqlExecutor = sqlExecutor;
    }

    public SQLParser getSqlParser() {
        return this.sqlParser;
    }

    public void setSqlParser(SQLParser sqlParser) {
        this.sqlParser = sqlParser;
    }

    protected boolean isSelect(String sql) {
        String s = sql.trim().toLowerCase();
        return s.startsWith("select");
    }

    protected Object executeByDataSource(DataSource dataSource, String sql, ScriptContext context) throws ScriptException {
        String newSql = sql;
        ScriptContext newContext = context;
        try {
            if (this.buildNewContext(context)) {
                newContext = new DefaultScriptContext(context.getTotalItemMap());
                this.clearNullValue(newContext);
            }
            if (this.isSelect(newSql)) {
                SqlRowSet sqlRowSet = this.sqlExecutor.queryForSqlRowSet(newSql, dataSource, (Context)newContext);
                return new SqlRowSetDataSet(sqlRowSet, ScriptContextUtil.getScriptEngine((ScriptContext)context).isIndexFromOne());
            }
            return this.executeBySqlExecutor(newSql, dataSource, newContext);
        }
        catch (Exception e) {
            throw new ScriptException((Throwable)e);
        }
    }

    private Object executeBySqlExecutor(String newSql, DataSource dataSource, ScriptContext context) throws Exception {
        int tag = this.sqlExecutor.execute(newSql, dataSource, (Context)context);
        return context.exist("GENERATE_KEY") ? context.get("GENERATE_KEY") : Integer.valueOf(tag);
    }

    private boolean buildNewContext(ScriptContext context) {
        return context.exist(SQL_ALLOW_NULL) && !ExpressionUtil.getBooleanValue((Object)context.get(SQL_ALLOW_NULL));
    }

    private void clearNullValue(ScriptContext context) {
        ArrayList delKeys = new ArrayList();
        for (Map.Entry entry : context.getItemMap().entrySet()) {
            if (entry.getValue() != null) continue;
            delKeys.add(entry.getKey());
        }
        for (String key : delKeys) {
            context.getItemMap().remove(key);
        }
    }
}

