/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.xmlparser.node;

import java.io.File;
import java.io.InputStream;
import java.util.List;
import junit.framework.TestCase;
import org.tinygroup.commons.file.IOUtils;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.vfs.VFS;
import org.tinygroup.xmlparser.XmlDocument;
import org.tinygroup.xmlparser.node.XmlNode;
import org.tinygroup.xmlparser.parser.XmlStringParser;

public class XmlNodeTest
extends TestCase {
    XmlDocument doc = null;

    protected void setUp() throws Exception {
        File file1 = new File("src/test/resources/dtd.xml");
        System.out.println(file1.getAbsolutePath());
        XmlStringParser parser = new XmlStringParser();
        FileObject file = VFS.resolveFile((String)("file:" + file1.getAbsolutePath()));
        this.doc = parser.parse(IOUtils.readFromInputStream((InputStream)file.getInputStream(), (String)"utf-8"));
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetSubNodes() {
        XmlNode node = (XmlNode)this.doc.getRoot();
        List subNodes = node.getSubNodes("from");
        XmlNodeTest.assertEquals((int)5, (int)subNodes.size());
    }

    public void testGetProgenyNodes() {
        XmlNode node = (XmlNode)this.doc.getRoot();
        List progenyNodes = node.getSubNodesRecursively("from");
        XmlNodeTest.assertEquals((int)7, (int)progenyNodes.size());
    }

    public void testGetSubNode() {
        XmlNode node = (XmlNode)this.doc.getRoot();
        XmlNode subNode = (XmlNode)node.getSubNode("zhang1");
        XmlNodeTest.assertNull((Object)subNode);
    }

    public void testGetProgenyNode() {
        XmlNode node = (XmlNode)this.doc.getRoot();
        XmlNode progenyNode = (XmlNode)node.getSubNodeRecursively("zhang1");
        XmlNodeTest.assertNotNull((Object)progenyNode);
        XmlNodeTest.assertEquals((String)"abcd", (String)progenyNode.getContent());
    }
}

