/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.xmlparser;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.tinygroup.commons.file.IOUtils;
import org.tinygroup.commons.tools.Native2AsciiUtils;
import org.tinygroup.parser.Document;
import org.tinygroup.parser.Node;
import org.tinygroup.parser.filter.FastNameFilter;
import org.tinygroup.parser.filter.NameFilter;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.vfs.VFS;
import org.tinygroup.xmlparser.XmlDocument;
import org.tinygroup.xmlparser.formatter.XmlFormater;
import org.tinygroup.xmlparser.node.XmlNode;
import org.tinygroup.xmlparser.parser.XmlStringParser;

public class MetadataGenerateEA {
    static String packageName = "org.tinygroup";
    Map<String, String> stdFieldsMap = new HashMap<String, String>();
    Map<String, String> i18nMap = new HashMap<String, String>();
    static Map<String, String> typeMap = new HashMap<String, String>();
    static Map<String, HashSet<String>> customTypeMap = new HashMap<String, HashSet<String>>();
    static XmlDocument doc = null;
    static String outputFolder = "c:/out2/";
    static String basePackagePath = "org.tinygroup";

    public static void main(String[] args) throws Exception {
        File file1 = new File("src/test/resources/schema.xml");
        System.out.println(file1.getAbsolutePath());
        XmlStringParser parser = new XmlStringParser();
        FileObject file = VFS.resolveFile((String)("file:" + file1.getAbsolutePath()));
        doc = parser.parse(IOUtils.readFromInputStream((InputStream)file.getInputStream(), (String)"UTF-8"));
        MetadataGenerateEA mg = new MetadataGenerateEA();
        mg.export("Document");
        mg.export("Product");
        mg.export("Project");
        mg.export("Quality");
        mg.export("Report");
        mg.export("Service");
        mg.export("common");
        mg.exportCustomType();
    }

    private void exportCustomType() throws Exception {
        StringBuffer buf = new StringBuffer("<business-types name=\"" + basePackagePath + "\" title=\"\u4e1a\u52a1\u7c7b\u578b\" package-name=\"" + basePackagePath + "\">");
        for (String type : customTypeMap.keySet()) {
            HashSet<String> lengthSet = customTypeMap.get(type);
            for (String length : lengthSet) {
                buf.append("<business-type id=\"" + typeMap.get(type) + length + "\" name=\"" + type + length + "\" title=\"" + type + length + "\" standard-type-id=\"type_" + typeMap.get(type).toLowerCase() + "\">");
                buf.append("<placeholder-value-list>");
                buf.append("<placeholder-value name=\"length\" value=\"" + length + "\" />");
                buf.append("</placeholder-value-list>");
                buf.append("</business-type>");
            }
        }
        buf.append("</business-types");
        MetadataGenerateEA.writeBuf(buf.toString(), outputFolder + "businessdatatype.bizdatatype.xml");
    }

    public void export(String moduleName) throws Exception {
        this.exportModule(moduleName);
        this.exportStdField(moduleName);
        this.exportI18nField(moduleName);
    }

    private void exportI18nField(String module) throws Exception {
        StringBuffer buf = new StringBuffer();
        for (String key : this.i18nMap.keySet()) {
            String value = this.i18nMap.get(key);
            key = MetadataGenerateEA.getLowerCase(key);
            buf.append(String.format("%s=%s\n", key, Native2AsciiUtils.native2Ascii((String)value)));
        }
        MetadataGenerateEA.writeBuf(buf.toString(), outputFolder + "i18n/" + module + "_zn_CN.properties");
    }

    private void exportStdField(String module) throws Exception {
        StringBuffer buf = new StringBuffer("<standard-fields package-name=\"" + packageName + "." + module.toLowerCase() + "\">\n");
        for (String key : this.stdFieldsMap.keySet()) {
            String[] string = this.stdFieldsMap.get(key).split(",");
            key = MetadataGenerateEA.getLowerCase(key);
            buf.append(String.format("<standard-field id=\"%s\" name=\"%s\" title=\"%s\" business-type-id=\"%s\" />\n", key, key, string[0], string[1]));
        }
        buf.append("</standard-fields>\n");
        MetadataGenerateEA.writeBuf(buf.toString(), outputFolder + module + ".stdfield.xml");
    }

    private void exportModule(String moduleName) throws Exception {
        FastNameFilter fast = new FastNameFilter(doc.getRoot());
        List elementList = fast.findNodeList("element");
        String moduleId = MetadataGenerateEA.getModuleId((XmlNode)doc.getRoot(), moduleName);
        for (XmlNode element : elementList) {
            XmlNode subNode = (XmlNode)element.getSubNode("model");
            if (subNode == null || !subNode.getAttribute("package").equals(moduleId)) continue;
            System.out.println(moduleName + "-->" + ((XmlNode)element.getSubNode("properties")).getAttribute("alias"));
            this.exportTable(moduleName, (XmlNode)doc.getRoot(), element, outputFolder);
        }
    }

    private static String getModuleId(XmlNode root, String moduleName) {
        NameFilter filter = new NameFilter((Node)root);
        HashMap<String, String> atts = new HashMap<String, String>();
        atts.put("name", moduleName);
        atts.put("xmi:type", "uml:Package");
        filter.setIncludeAttribute(atts);
        XmlNode node = (XmlNode)filter.findNode("element");
        return node.getAttribute("xmi:idref");
    }

    private void exportTable(String moduleName, XmlNode root, XmlNode element, String outputFolder) throws Exception {
        XmlNode properties = (XmlNode)element.getSubNode("properties");
        if (properties != null && properties.getAttribute("stereotype") != null && properties.getAttribute("stereotype").equals("table")) {
            StringBuffer buf = new StringBuffer();
            String name = element.getAttribute("name");
            String cname = properties.getAttribute("alias") == null ? "" : properties.getAttribute("alias");
            this.i18nMap.put(name, cname);
            buf.append(String.format("<entity-model uuid=\"%s_uuid\" name=\"%s\" title=\"%s\" ignore=\"false\" description=\"%s\" enable-delete=\"true\" enable-modity=\"true\" version=\"2.0\" cache-enabled=\"true\" package-name=\"%s\">", name, name, cname, cname, packageName + "." + moduleName.toLowerCase()));
            this.processAtrribute(root, element, buf);
            MetadataGenerateEA.printOperations(root, element, buf);
            buf.append("</entity-model>");
            File folder = new File(outputFolder + moduleName);
            if (!folder.exists()) {
                folder.mkdirs();
            }
            String fileName = outputFolder + moduleName + File.separator + name + ".entity.xml";
            MetadataGenerateEA.writeBuf(buf.toString(), fileName);
        }
    }

    private static void writeBuf(String buf, String fileName) throws Exception {
        System.out.println("write to file: " + fileName);
        File file = new File(fileName).getParentFile();
        if (!file.exists()) {
            file.mkdirs();
        }
        FileOutputStream outputStream = new FileOutputStream(fileName);
        if (fileName.endsWith(".xml")) {
            outputStream.write(MetadataGenerateEA.formatXml(buf.toString()).getBytes("UTF-8"));
        } else {
            outputStream.write(buf.toString().getBytes("UNICODE"));
        }
        outputStream.close();
    }

    private static String formatXml(String string) {
        XmlFormater f = new XmlFormater();
        XmlDocument doc = new XmlStringParser().parse(string);
        return f.format((Document)doc);
    }

    private void processAtrribute(XmlNode root, XmlNode element, StringBuffer buf) {
        buf.append("<groups>");
        buf.append("<group uuid=\"basicgroup\" name=\"basicgroup\" title=\"\u57fa\u672c\u4fe1\u606f\" description=\"\u57fa\u672c\u4fe1\u606f\" enable-delete=\"true\" enable-modity=\"true\">");
        buf.append("<fields>");
        XmlNode attributes = (XmlNode)element.getSubNode("attributes");
        if (attributes != null) {
            List nodeList = attributes.getSubNodes("attribute");
            for (XmlNode att : nodeList) {
                String type = ((XmlNode)att.getSubNode("properties")).getAttribute("type");
                String length = ((XmlNode)att.getSubNode("properties")).getAttribute("length");
                if (length != null && !length.equals("0")) {
                    HashSet<String> set = customTypeMap.get(type);
                    if (set == null) {
                        set = new HashSet();
                        customTypeMap.put(type, set);
                    }
                    if (!set.contains(length)) {
                        set.add(length);
                    }
                } else {
                    length = "";
                }
                XmlNode style = (XmlNode)att.getSubNode("style");
                String cname = null;
                if (style != null) {
                    cname = style.getAttribute("value");
                }
                if (cname == null) {
                    cname = "";
                }
                String name = att.getAttribute("name");
                name = MetadataGenerateEA.getLowerCase(name);
                if (type == null) {
                    System.out.println("Error:" + name);
                    continue;
                }
                boolean primary = MetadataGenerateEA.isPrimary(root, element, name);
                boolean unique = MetadataGenerateEA.isUnique(root, element, name);
                buf.append(String.format("<field standard-field=\"%s\" primary=\"%s\" unique=\"%s\" display=\"false\" uuid=\"%s_uuid\" />", name, primary, unique, name));
                this.i18nMap.put(name, cname);
                if (length.length() == 0) {
                    this.stdFieldsMap.put(name, cname + "," + MetadataGenerateEA.getBizType(type, null));
                    continue;
                }
                this.stdFieldsMap.put(name, cname + "," + MetadataGenerateEA.getBizType(type, length));
            }
        }
        buf.append("</fields>");
        buf.append("</group>");
        buf.append("</groups>");
    }

    private static String getBizType(String type, String length) {
        String string = typeMap.get(type.toUpperCase());
        if (string == null) {
            throw new RuntimeException("mistake type:" + type);
        }
        if (length == null) {
            return string;
        }
        return string + length;
    }

    private static String getLowerCase(String str) {
        str = str.replaceAll("_ID", "Id");
        str = str.replaceAll("ID", "Id");
        StringBuffer sb = new StringBuffer();
        String[] strArray = str.split("_");
        for (int i = 0; i < strArray.length; ++i) {
            String word;
            if (i > 0) {
                sb.append("_");
            }
            if ((word = strArray[i]).equalsIgnoreCase("id")) {
                sb.append(word.toLowerCase());
                continue;
            }
            for (int j = 0; j < word.length(); ++j) {
                char ch = word.charAt(j);
                if (ch >= 'A' && ch <= 'Z') {
                    if (j != 0) {
                        sb.append("_");
                    }
                    sb.append((char)(ch - 65 + 97));
                    continue;
                }
                sb.append(ch);
            }
        }
        return sb.toString();
    }

    private static boolean isPrimary(XmlNode root, XmlNode element, String name) {
        XmlNode operations = (XmlNode)element.getSubNode("operations");
        if (operations != null) {
            List nodeList = operations.getSubNodes("operation");
            for (XmlNode operation : nodeList) {
                XmlNode stereotype = (XmlNode)operation.getSubNode("stereotype");
                if (stereotype == null || !stereotype.getAttribute("stereotype").equals("PK")) continue;
                NameFilter filter = new NameFilter((Node)root);
                filter.setIncludeAttribute("xmi:id", operation.getAttribute("xmi:idref"));
                XmlNode node = (XmlNode)filter.findNode("ownedOperation");
                List parameterList = node.getSubNodes("ownedParameter");
                if (parameterList.size() != 1 || !MetadataGenerateEA.getLowerCase(((XmlNode)parameterList.get(0)).getAttribute("name")).equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isUnique(XmlNode root, XmlNode element, String name) {
        XmlNode operations = (XmlNode)element.getSubNode("operations");
        if (operations != null) {
            List nodeList = operations.getSubNodes("operation");
            for (XmlNode operation : nodeList) {
                XmlNode stereotype = (XmlNode)operation.getSubNode("stereotype");
                if (stereotype == null || !stereotype.getAttribute("stereotype").equals("unique")) continue;
                NameFilter filter = new NameFilter((Node)root);
                filter.setIncludeAttribute("xmi:id", operation.getAttribute("xmi:idref"));
                XmlNode node = (XmlNode)filter.findNode("ownedOperation");
                List parameterList = node.getSubNodes("ownedParameter");
                if (parameterList == null || parameterList.size() != 1 || !MetadataGenerateEA.getLowerCase(((XmlNode)parameterList.get(0)).getAttribute("name")).equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    private static void printOperations(XmlNode root, XmlNode element, StringBuffer buf) {
        XmlNode operations = (XmlNode)element.getSubNode("operations");
        if (operations != null) {
            List nodeList = operations.getSubNodes("operation");
            for (XmlNode operation : nodeList) {
                XmlNode stereotype = (XmlNode)operation.getSubNode("stereotype");
                if (stereotype == null) continue;
                if (stereotype.getAttribute("stereotype").equals("PK")) {
                    MetadataGenerateEA.printPK(root, element, operation);
                    continue;
                }
                if (stereotype.getAttribute("stereotype").equals("unique")) {
                    System.out.println(MetadataGenerateEA.getUnique(root, element, operation));
                    continue;
                }
                if (!stereotype.getAttribute("stereotype").equals("index")) continue;
                System.out.println(MetadataGenerateEA.getIndex(root, element, operation));
            }
        }
    }

    private static void printPK(XmlNode root, XmlNode element, XmlNode operation) {
        NameFilter filter = new NameFilter((Node)root);
        filter.setIncludeAttribute("xmi:id", operation.getAttribute("xmi:idref"));
        XmlNode node = (XmlNode)filter.findNode("ownedOperation");
        MetadataGenerateEA.getParameters(node);
    }

    private static String getUnique(XmlNode root, XmlNode element, XmlNode operation) {
        NameFilter filter = new NameFilter((Node)root);
        filter.setIncludeAttribute("xmi:id", operation.getAttribute("xmi:idref"));
        XmlNode node = (XmlNode)filter.findNode("ownedOperation");
        return MetadataGenerateEA.getParameters(node);
    }

    private static String getIndex(XmlNode root, XmlNode element, XmlNode operation) {
        NameFilter filter = new NameFilter((Node)root);
        filter.setIncludeAttribute("xmi:id", operation.getAttribute("xmi:idref"));
        XmlNode node = (XmlNode)filter.findNode("ownedOperation");
        return MetadataGenerateEA.getParameters(node);
    }

    private static String getParameters(XmlNode node) {
        StringBuffer sb = new StringBuffer();
        List parameterList = node.getSubNodes("ownedParameter");
        if (parameterList != null) {
            for (XmlNode para : parameterList) {
                if (sb.length() <= 0) continue;
                sb.append(",");
                sb.append(para.getAttribute("name"));
            }
        }
        return sb.toString();
    }

    static {
        typeMap.put("SMALLINT", "SmallInt");
        typeMap.put("MEDIUMINT", "MediumInt");
        typeMap.put("VARCHAR", "Varchar");
        typeMap.put("FLOAT", "Float");
        typeMap.put("TINYINT", "TinyInt");
        typeMap.put("TEXT", "Text");
        typeMap.put("ENUM", "TinyText");
        typeMap.put("DATETIME", "Datetime");
        typeMap.put("DATE", "Date");
        typeMap.put("CHAR", "Varchar");
        typeMap.put("INTEGER", "Integer");
        typeMap.put("BOOL", "TinyInt");
        typeMap.put("BIGINT", "BigInt");
        typeMap.put("DECIMAL", "Decimal");
        typeMap.put("TIMESTAMP", "Timestamp");
    }
}

