/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.xmlparser;

import java.io.OutputStream;
import java.util.Hashtable;
import junit.framework.TestCase;
import org.tinygroup.parser.Node;
import org.tinygroup.parser.NodeFilter;
import org.tinygroup.parser.filter.NameFilter;
import org.tinygroup.xmlparser.formatter.XmlFormater;
import org.tinygroup.xmlparser.node.XmlNode;

public class INodeFilterTest
extends TestCase {
    XmlNode node = null;
    NodeFilter filter;

    protected void setUp() throws Exception {
        super.setUp();
        this.node = new XmlNode("root");
        XmlNode n1 = (XmlNode)this.node.addNode((Node)new XmlNode("aa"));
        n1.setAttribute("a", "av");
        n1.setAttribute("b", "bv");
        n1.addNode((Node)new XmlNode("a"));
        n1 = (XmlNode)this.node.addNode((Node)new XmlNode("aa"));
        n1.setAttribute("a", "av1");
        n1.setAttribute("b", "bv1");
        n1.setAttribute("c", "cv1");
        n1.addNode((Node)new XmlNode("b"));
        XmlFormater formater = new XmlFormater();
        formater.format((Node)this.node, (OutputStream)System.out);
        this.filter = new NameFilter((Node)this.node);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testClearCondition() {
        this.filter.clearCondition();
        INodeFilterTest.assertEquals((int)2, (int)this.filter.findNodeList("aa").size());
    }

    public void testFindNodeList() {
        this.filter.clearCondition();
        INodeFilterTest.assertEquals((int)1, (int)this.filter.findNodeList("root").size());
        this.filter.setExcludeAttribute(new String[]{"c"});
        INodeFilterTest.assertEquals((int)1, (int)this.filter.findNodeList("aa").size());
        this.filter.clearCondition();
        INodeFilterTest.assertEquals((int)1, (int)this.filter.findNodeList("root").size());
        this.filter.setIncludeAttributes(new String[]{"c"});
        INodeFilterTest.assertEquals((int)1, (int)this.filter.findNodeList("aa").size());
        this.filter.clearCondition();
        Hashtable<String, String> pht = new Hashtable<String, String>();
        pht.put("a", "av1");
        this.filter.setIncludeAttribute(pht);
        INodeFilterTest.assertEquals((int)1, (int)this.filter.findNodeList("aa").size());
        this.filter.setExcludeAttribute(new String[]{"c"});
        INodeFilterTest.assertEquals((int)0, (int)this.filter.findNodeList("aa").size());
        this.filter.clearCondition();
        this.filter.setIncludeNode(new String[]{"a"});
        INodeFilterTest.assertEquals((int)1, (int)this.filter.findNodeList("aa").size());
        this.filter.setIncludeAttributes(new String[]{"c"});
        INodeFilterTest.assertEquals((int)0, (int)this.filter.findNodeList("aa").size());
        this.filter.clearCondition();
        this.filter.setExcludeNode(new String[]{"c"});
        INodeFilterTest.assertEquals((int)2, (int)this.filter.findNodeList("aa").size());
    }
}

