/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.xmlparser;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.tinygroup.commons.file.IOUtils;
import org.tinygroup.commons.namestrategy.impl.CamelCaseStrategy;
import org.tinygroup.commons.tools.CollectionUtil;
import org.tinygroup.commons.tools.Native2AsciiUtils;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.parser.Document;
import org.tinygroup.parser.Node;
import org.tinygroup.parser.filter.FastNameFilter;
import org.tinygroup.parser.filter.NameFilter;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.vfs.VFS;
import org.tinygroup.xmlparser.XmlDocument;
import org.tinygroup.xmlparser.formatter.XmlFormater;
import org.tinygroup.xmlparser.node.XmlNode;
import org.tinygroup.xmlparser.parser.XmlStringParser;

public class MetadataGeneratePDM {
    static String packageName = "org.tinygroup";
    Map<String, String> stdFieldsMap = new HashMap<String, String>();
    Map<String, String> i18nMap = new HashMap<String, String>();
    static Map<String, String> typeMap = new HashMap<String, String>();
    static Map<String, HashSet<String>> customTypeMap = new HashMap<String, HashSet<String>>();
    CamelCaseStrategy camelCaseStrategy = new CamelCaseStrategy();
    static XmlDocument doc = null;
    static String outputFolder = "c:/out/";
    static String basePackagePath = "aa.bb";

    public static void main(String[] args) throws Exception {
        File file1 = new File("C://Users//renhui.HS//Desktop//demo.pdm");
        System.out.println(file1.getAbsolutePath());
        XmlStringParser parser = new XmlStringParser();
        FileObject file = VFS.resolveFile((String)("file:" + file1.getAbsolutePath()));
        doc = parser.parse(IOUtils.readFromInputStream((InputStream)file.getInputStream(), (String)"UTF-8"));
        MetadataGeneratePDM mg = new MetadataGeneratePDM();
        mg.export("all");
        mg.exportCustomType();
    }

    private void exportCustomType() throws Exception {
        StringBuffer buf = new StringBuffer("<business-types name=\"" + basePackagePath + "\" title=\"\u4e1a\u52a1\u7c7b\u578b\" package-name=\"" + basePackagePath + "\">");
        for (String type : customTypeMap.keySet()) {
            HashSet<String> lengthSet = customTypeMap.get(type);
            for (String length : lengthSet) {
                if ("NUMERIC".equals(type = type.toUpperCase()) || "NUMBER".endsWith(type)) {
                    if (length.indexOf(",") != -1) {
                        String[] lens = length.split(",");
                        String len = lens[0];
                        String scale = lens[1];
                        String type2 = MetadataGeneratePDM.getNumberType(type, len, scale);
                        buf.append("<business-type id=\"" + typeMap.get(type2) + len + "\" name=\"" + type2 + "\" title=\"" + type2 + "\" standard-type-id=\"type_" + typeMap.get(type2).toLowerCase() + "\">");
                        buf.append("<placeholder-value-list>");
                        buf.append("<placeholder-value name=\"precision\" value=\"" + len + "\" />");
                        buf.append("<placeholder-value name=\"scale\" value=\"" + scale + "\" />");
                        buf.append("</placeholder-value-list>");
                        buf.append("</business-type>");
                        continue;
                    }
                    String type2 = MetadataGeneratePDM.getNumberType(type, length, "0");
                    buf.append("<business-type id=\"" + typeMap.get(type2) + length + "\" name=\"" + type2 + length + "\" title=\"" + type2 + length + "\" standard-type-id=\"type_" + typeMap.get(type2).toLowerCase() + "\">");
                    buf.append("<placeholder-value-list>");
                    buf.append("<placeholder-value name=\"length\" value=\"" + length + "\" />");
                    buf.append("</placeholder-value-list>");
                    buf.append("</business-type>");
                    continue;
                }
                buf.append("<business-type id=\"" + typeMap.get(type) + length + "\" name=\"" + type + length + "\" title=\"" + type + length + "\" standard-type-id=\"type_" + typeMap.get(type).toLowerCase() + "\">");
                if (!"".equals(length)) {
                    buf.append("<placeholder-value-list>");
                    buf.append("<placeholder-value name=\"length\" value=\"" + length + "\" />");
                    buf.append("</placeholder-value-list>");
                }
                buf.append("</business-type>");
            }
        }
        buf.append("</business-types");
        MetadataGeneratePDM.writeBuf(buf.toString(), outputFolder + "businessdatatype.bizdatatype.xml");
    }

    public void export(String moduleName) throws Exception {
        this.exportModule(moduleName);
        this.exportStdField(moduleName);
        this.exportI18nField(moduleName);
    }

    private void exportI18nField(String module) throws Exception {
        StringBuffer buf = new StringBuffer();
        for (String key : this.i18nMap.keySet()) {
            String value = this.i18nMap.get(key);
            key = MetadataGeneratePDM.getLowerCase(key);
            buf.append(String.format("%s=%s\n", key, Native2AsciiUtils.native2Ascii((String)value)));
        }
        MetadataGeneratePDM.writeBuf(buf.toString(), outputFolder + "i18n/" + module + "_zn_CN.properties");
    }

    private void exportStdField(String module) throws Exception {
        StringBuffer buf = new StringBuffer("<standard-fields package-name=\"" + packageName + "." + module.toLowerCase() + "\">\n");
        for (String key : this.stdFieldsMap.keySet()) {
            String[] string = this.stdFieldsMap.get(key).split(",");
            key = MetadataGeneratePDM.getLowerCase(key);
            buf.append(String.format("<standard-field id=\"%s\" name=\"%s\" title=\"%s\" business-type-id=\"%s\" />\n", key, key, string[0], string[1]));
        }
        buf.append("</standard-fields>\n");
        MetadataGeneratePDM.writeBuf(buf.toString(), outputFolder + module + ".stdfield.xml");
    }

    private void exportModule(String moduleName) throws Exception {
        FastNameFilter fast = new FastNameFilter(doc.getRoot());
        List elementList = fast.findNodeList("o:Model");
        for (XmlNode element : elementList) {
            XmlNode packages = (XmlNode)element.getSubNode("c:Packages");
            if (packages != null) {
                this.exportPackages(packages);
                continue;
            }
            String module_name = ((XmlNode)element.getSubNode("a:Code")).getContent();
            this.exportTables(element, module_name);
        }
    }

    private void exportPackages(XmlNode node) throws Exception {
        List packages;
        if (node != null && !CollectionUtil.isEmpty((Collection)(packages = node.getSubNodes("o:Package")))) {
            for (XmlNode packageNode : packages) {
                String module_name = ((XmlNode)packageNode.getSubNode("a:Code")).getContent();
                XmlNode packagesNode = (XmlNode)packageNode.getSubNode("c:Packages");
                if (packagesNode != null) {
                    this.exportPackages(packagesNode);
                    continue;
                }
                this.exportTables(packageNode, module_name);
            }
        }
    }

    private void exportTables(XmlNode xmlNode, String module_name) throws Exception {
        List tableNodes = ((XmlNode)xmlNode.getSubNode("c:Tables")).getSubNodes("o:Table");
        if (!CollectionUtil.isEmpty((Collection)tableNodes)) {
            for (XmlNode table : tableNodes) {
                this.exportTable(module_name, null, table, outputFolder);
            }
        }
    }

    private static String getModuleId(XmlNode root, String moduleName) {
        NameFilter filter = new NameFilter((Node)root);
        HashMap<String, String> atts = new HashMap<String, String>();
        atts.put("name", moduleName);
        atts.put("xmi:type", "uml:Package");
        filter.setIncludeAttribute(atts);
        XmlNode node = (XmlNode)filter.findNode("element");
        return node.getAttribute("xmi:idref");
    }

    private void exportTable(String moduleName, XmlNode root, XmlNode tableNode, String outputFolder) throws Exception {
        StringBuffer buf = new StringBuffer();
        String tableName = ((XmlNode)tableNode.getSubNode("a:Code")).getContent();
        String cname = ((XmlNode)tableNode.getSubNode("a:Name")).getContent() == null ? "" : ((XmlNode)tableNode.getSubNode("a:Name")).getContent();
        this.i18nMap.put(tableName, cname);
        buf.append(String.format("<entity-model id=\"%s\" name=\"%s\" title=\"%s\" ignore=\"false\" description=\"%s\" enable-delete=\"true\" enable-modity=\"true\" version=\"2.0\" cache-enabled=\"true\" package-name=\"%s\">", this.camelCaseStrategy.getPropertyName(tableName), tableName, cname, cname, packageName + "." + moduleName.toLowerCase()));
        this.processAtrribute(root, tableNode, buf);
        MetadataGeneratePDM.printOperations(root, tableNode, buf);
        buf.append("</entity-model>");
        File folder = new File(outputFolder + moduleName);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        String fileName = outputFolder + moduleName + File.separator + tableName + ".entity.xml";
        MetadataGeneratePDM.writeBuf(buf.toString(), fileName);
    }

    private static void writeBuf(String buf, String fileName) throws Exception {
        System.out.println("write to file: " + fileName);
        File file = new File(fileName).getParentFile();
        if (!file.exists()) {
            file.mkdirs();
        }
        FileOutputStream outputStream = new FileOutputStream(fileName);
        if (fileName.endsWith(".xml")) {
            outputStream.write(MetadataGeneratePDM.formatXml(buf.toString()).getBytes("UTF-8"));
        } else {
            outputStream.write(buf.toString().getBytes("UNICODE"));
        }
        outputStream.close();
    }

    private static String formatXml(String string) {
        XmlFormater f = new XmlFormater();
        XmlDocument doc = new XmlStringParser().parse(string);
        return f.format((Document)doc);
    }

    private void processAtrribute(XmlNode root, XmlNode tableNode, StringBuffer buf) {
        buf.append("<groups>");
        buf.append("<group id=\"basicgroup\" name=\"basicgroup\" title=\"\u57fa\u672c\u4fe1\u606f\" description=\"\u57fa\u672c\u4fe1\u606f\" enable-delete=\"true\" enable-modity=\"true\">");
        List nodeList = ((XmlNode)tableNode.getSubNode("c:Columns")).getSubNodes("o:Column");
        for (XmlNode att : nodeList) {
            boolean primary;
            HashSet<String> set;
            String precision;
            String col_id = att.getAttribute("Id");
            String type = ((XmlNode)att.getSubNode("a:DataType")).getContent();
            String length = att.getSubNode("a:Length") == null ? null : ((XmlNode)att.getSubNode("a:Length")).getContent();
            String string = precision = att.getSubNode("a:Precision") == null ? "0" : ((XmlNode)att.getSubNode("a:Precision")).getContent();
            if (type != null && type.indexOf("2") != -1) {
                type = type.substring(0, type.indexOf("2"));
            }
            if (type != null && type.indexOf("(") != -1) {
                type = type.substring(0, type.indexOf("("));
            }
            if (length != null && !length.equals("0")) {
                if (precision != null && !"0".equals(precision)) {
                    set = customTypeMap.get("NUMBER");
                    String len = length + "," + precision;
                    if (set == null) {
                        set = new HashSet();
                        customTypeMap.put(type, set);
                    }
                    if (!set.contains(len)) {
                        set.add(len);
                    }
                } else {
                    set = customTypeMap.get(type);
                    if (set == null) {
                        set = new HashSet();
                        customTypeMap.put(type, set);
                    }
                    if (!set.contains(length)) {
                        set.add(length);
                    }
                }
            } else {
                length = "";
                set = customTypeMap.get(type);
                if (set == null) {
                    set = new HashSet();
                    customTypeMap.put(type, set);
                }
                if (!set.contains(length)) {
                    set.add(length);
                }
            }
            String cname = ((XmlNode)att.getSubNode("a:Name")).getContent();
            if (cname == null) {
                cname = "";
            }
            String name = ((XmlNode)att.getSubNode("a:Code")).getContent();
            name = MetadataGeneratePDM.getLowerCase(name);
            if (type == null) {
                System.out.println("Error:" + name);
                continue;
            }
            boolean unique = primary = MetadataGeneratePDM.isPrimary(null, tableNode, col_id);
            buf.append(String.format("<field standard-field-id=\"%s\" primary=\"%s\"  unique=\"%s\" display=\"false\" id=\"%s_uuid\" table-field=\"true\" />", name, primary, unique, name));
            this.i18nMap.put(name, cname);
            if (length.length() == 0) {
                this.stdFieldsMap.put(name, cname + "," + MetadataGeneratePDM.getBizType(type, null, null));
                continue;
            }
            if ("DECIMAL8".equals(MetadataGeneratePDM.getBizType(type, length, precision))) {
                System.out.println("DECIMAL8");
            }
            this.stdFieldsMap.put(name, cname + "," + MetadataGeneratePDM.getBizType(type, length, precision));
        }
        buf.append("</group>");
        buf.append("</groups>");
    }

    private static String getBizType(String type, String length, String precision) {
        String string = typeMap.get(type.toUpperCase());
        if ("NUMBER".equals(type.toUpperCase()) || "NUMERIC".equals(type.toUpperCase())) {
            string = typeMap.get(MetadataGeneratePDM.getNumberType(type, length, precision));
        }
        if (string == null) {
            throw new RuntimeException("mistake type:" + type);
        }
        if (length == null) {
            return string;
        }
        return string + length;
    }

    private static String getNumberType(String type, String length, String precision) {
        String string = "";
        string = "0".equals(precision) ? (StringUtil.isBlank((String)length) ? "BIGINT" : (Integer.parseInt(length) <= 3 ? "TINYINT" : (Integer.parseInt(length) > 3 && Integer.parseInt(length) <= 5 ? "SMALLINT" : (Integer.parseInt(length) > 5 && Integer.parseInt(length) <= 8 ? "MEDIUMINT" : "BIGINT")))) : "DECIMAL";
        return string;
    }

    private static String getLowerCase(String str) {
        str = str.replaceAll("_ID", "Id");
        str = str.replaceAll("ID", "Id");
        StringBuffer sb = new StringBuffer();
        String[] strArray = str.split("_");
        for (int i = 0; i < strArray.length; ++i) {
            String word;
            if (i > 0) {
                sb.append("_");
            }
            if ((word = strArray[i]).equalsIgnoreCase("id")) {
                sb.append(word.toLowerCase());
                continue;
            }
            for (int j = 0; j < word.length(); ++j) {
                char ch = word.charAt(j);
                if (ch >= 'A' && ch <= 'Z') {
                    if (j != 0) {
                        sb.append("_");
                    }
                    sb.append((char)(ch - 65 + 97));
                    continue;
                }
                sb.append(ch);
            }
        }
        return sb.toString();
    }

    private static boolean isPrimary(XmlNode root, XmlNode tableNode, String colId) {
        List primaryKeys;
        List keys = tableNode.getSubNode("c:Keys") == null ? null : ((XmlNode)tableNode.getSubNode("c:Keys")).getSubNodes("o:Key");
        List list = primaryKeys = tableNode.getSubNode("c:PrimaryKey") == null ? null : ((XmlNode)tableNode.getSubNode("c:PrimaryKey")).getSubNodes("o:Key");
        if (keys != null) {
            for (XmlNode key : keys) {
                String keyid = key.getAttribute("Id");
                List key_cols = key.getSubNode("c:Key.Columns") == null ? null : ((XmlNode)key.getSubNode("c:Key.Columns")).getSubNodes("o:Column");
                if (key_cols == null) continue;
                for (XmlNode key_col : key_cols) {
                    String col_id = key_col.getAttribute("Ref");
                    if (col_id == null || !col_id.equals(colId) || primaryKeys == null) continue;
                    for (XmlNode pk : primaryKeys) {
                        String pk_id = pk.getAttribute("Ref");
                        if (pk_id == null || !pk_id.equals(keyid)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static boolean isUnique(XmlNode root, XmlNode element, String name) {
        XmlNode operations = (XmlNode)element.getSubNode("operations");
        if (operations != null) {
            List nodeList = operations.getSubNodes("operation");
            for (XmlNode operation : nodeList) {
                XmlNode stereotype = (XmlNode)operation.getSubNode("stereotype");
                if (stereotype == null || !stereotype.getAttribute("stereotype").equals("unique")) continue;
                NameFilter filter = new NameFilter((Node)root);
                filter.setIncludeAttribute("xmi:id", operation.getAttribute("xmi:idref"));
                XmlNode node = (XmlNode)filter.findNode("ownedOperation");
                List parameterList = node.getSubNodes("ownedParameter");
                if (parameterList == null || parameterList.size() != 1 || !MetadataGeneratePDM.getLowerCase(((XmlNode)parameterList.get(0)).getAttribute("name")).equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    private static void printOperations(XmlNode root, XmlNode element, StringBuffer buf) {
        XmlNode operations = (XmlNode)element.getSubNode("operations");
        if (operations != null) {
            List nodeList = operations.getSubNodes("operation");
            for (XmlNode operation : nodeList) {
                XmlNode stereotype = (XmlNode)operation.getSubNode("stereotype");
                if (stereotype == null) continue;
                if (stereotype.getAttribute("stereotype").equals("PK")) {
                    MetadataGeneratePDM.printPK(root, element, operation);
                    continue;
                }
                if (stereotype.getAttribute("stereotype").equals("unique")) {
                    System.out.println(MetadataGeneratePDM.getUnique(root, element, operation));
                    continue;
                }
                if (!stereotype.getAttribute("stereotype").equals("index")) continue;
                System.out.println(MetadataGeneratePDM.getIndex(root, element, operation));
            }
        }
    }

    private static void printPK(XmlNode root, XmlNode element, XmlNode operation) {
        NameFilter filter = new NameFilter((Node)root);
        filter.setIncludeAttribute("xmi:id", operation.getAttribute("xmi:idref"));
        XmlNode node = (XmlNode)filter.findNode("ownedOperation");
        MetadataGeneratePDM.getParameters(node);
    }

    private static String getUnique(XmlNode root, XmlNode element, XmlNode operation) {
        NameFilter filter = new NameFilter((Node)root);
        filter.setIncludeAttribute("xmi:id", operation.getAttribute("xmi:idref"));
        XmlNode node = (XmlNode)filter.findNode("ownedOperation");
        return MetadataGeneratePDM.getParameters(node);
    }

    private static String getIndex(XmlNode root, XmlNode element, XmlNode operation) {
        NameFilter filter = new NameFilter((Node)root);
        filter.setIncludeAttribute("xmi:id", operation.getAttribute("xmi:idref"));
        XmlNode node = (XmlNode)filter.findNode("ownedOperation");
        return MetadataGeneratePDM.getParameters(node);
    }

    private static String getParameters(XmlNode node) {
        StringBuffer sb = new StringBuffer();
        List parameterList = node.getSubNodes("ownedParameter");
        if (parameterList != null) {
            for (XmlNode para : parameterList) {
                if (sb.length() <= 0) continue;
                sb.append(",");
                sb.append(para.getAttribute("name"));
            }
        }
        return sb.toString();
    }

    static {
        typeMap.put("SMALLINT", "SmallInt");
        typeMap.put("MEDIUMINT", "MediumInt");
        typeMap.put("VARCHAR", "Varchar");
        typeMap.put("FLOAT", "Float");
        typeMap.put("TINYINT", "TinyInt");
        typeMap.put("TEXT", "Text");
        typeMap.put("ENUM", "TinyText");
        typeMap.put("DATETIME", "Datetime");
        typeMap.put("DATE", "Date");
        typeMap.put("CHAR", "Varchar");
        typeMap.put("INTEGER", "Integer");
        typeMap.put("BOOL", "TinyInt");
        typeMap.put("BIGINT", "BigInt");
        typeMap.put("DECIMAL", "Decimal");
        typeMap.put("TIMESTAMP", "Timestamp");
        typeMap.put("BLOB", "Blob");
        typeMap.put("CLOB", "Clob");
        typeMap.put("INT", "Int");
        typeMap.put("DOUBLE", "Double");
    }
}

