/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.xmlparser;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.tinygroup.commons.file.IOUtils;
import org.tinygroup.parser.Node;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.vfs.VFS;
import org.tinygroup.xmlparser.XmlDocument;
import org.tinygroup.xmlparser.formatter.XmlFormater;
import org.tinygroup.xmlparser.node.XmlNode;
import org.tinygroup.xmlparser.parser.XmlStringParser;

public class ProcessPom {
    public static void main(String[] args) throws Exception {
        File root = new File("E:/SVN/tinyorg-code/trunk/Sources");
        ProcessPom.processFolder(root);
    }

    private static void processFolder(File file) throws Exception {
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                if (f.getName().equals("pom.xml")) {
                    ProcessPom.processPom(f);
                }
                if (!f.isDirectory()) continue;
                ProcessPom.processFolder(f);
            }
        }
    }

    private static void processPom(File file) throws Exception {
        List subNodes;
        XmlNode dependencies;
        XmlStringParser parser = new XmlStringParser();
        FileObject fileObject = VFS.resolveFile((String)("file:" + file.getAbsolutePath()));
        XmlDocument doc = parser.parse(IOUtils.readFromInputStream((InputStream)fileObject.getInputStream(), (String)"UTF-8"));
        XmlNode root = (XmlNode)doc.getRoot();
        root.removeNode("version");
        root.removeNode("groupId");
        XmlNode parent = (XmlNode)root.getSubNode("parent");
        if (parent != null) {
            ((XmlNode)((XmlNode)parent.getSubNode("version")).getSubNodes().get(0)).setContent("0.0.5-SNAPSHOT");
        }
        if ((dependencies = (XmlNode)root.getSubNode("dependencies")) != null && (subNodes = dependencies.getSubNodes("dependency")) != null) {
            for (XmlNode dependency : subNodes) {
                if (!((XmlNode)dependency.getSubNode("groupId")).getContent().trim().equals("org.tinygroup")) continue;
                ((XmlNode)((XmlNode)dependency.getSubNode("version")).getSubNodes().get(0)).setContent("${tinyVersion}");
            }
        }
        XmlFormater formater = new XmlFormater();
        FileOutputStream outputStream = new FileOutputStream(file);
        IOUtils.writeToOutputStream((OutputStream)outputStream, (String)formater.format((Node)root), (String)"UTF-8");
        outputStream.close();
    }
}

