/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.xmlparser.node;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.tinygroup.commons.file.IOUtils;
import org.tinygroup.parser.Document;
import org.tinygroup.xmlparser.XmlDocument;
import org.tinygroup.xmlparser.formatter.XmlFormater;
import org.tinygroup.xmlparser.node.XmlNode;
import org.tinygroup.xmlparser.parser.XmlStringParser;

public class ChangePom {
    public static void main(String[] args) throws Throwable {
        File file1 = new File("D:\\SVN\\tinyorg-code\\trunk\\Sources\\");
        ChangePom.processFolder(file1);
    }

    private static void processFolder(File file1) throws Exception {
        File[] files;
        for (File file : files = file1.listFiles()) {
            if (file.isDirectory()) {
                ChangePom.processFolder(file);
            }
            if (!file.getName().equals("pom.xml")) continue;
            ChangePom.processPomFile(file);
        }
    }

    private static void processPomFile(File file) throws Exception {
        List dependencyList;
        System.out.println("processing:" + file.getAbsolutePath());
        XmlStringParser parser = new XmlStringParser();
        XmlDocument doc = parser.parse(IOUtils.readFromInputStream((InputStream)new FileInputStream(file), (String)"utf-8"));
        XmlNode dependencies = (XmlNode)((XmlNode)doc.getRoot()).getSubNode("dependencies");
        XmlNode projectArtifactId = (XmlNode)((XmlNode)doc.getRoot()).getSubNode("artifactId");
        if (dependencies != null && (dependencyList = dependencies.getSubNodes("dependency")) != null) {
            for (XmlNode node : dependencyList) {
                XmlNode artifactId;
                XmlNode groupId = (XmlNode)node.getSubNode("groupId");
                if (!groupId.getContent().trim().equals("org.tinygroup") || (artifactId = (XmlNode)node.getSubNode("artifactId")).getContent().indexOf("org.tinygroup") >= 0) continue;
                artifactId.setContent("org.tinygroup." + artifactId.getContent().trim());
            }
        }
        XmlFormater formater = new XmlFormater();
        IOUtils.writeToOutputStream((OutputStream)new FileOutputStream(file), (String)formater.format((Document)doc), (String)"UTF-8");
    }
}

