/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.xmlparser;

import org.tinygroup.parser.NodeType;
import org.tinygroup.parser.nodetype.NodeSign;
import org.tinygroup.parser.nodetype.NodeTypeImpl;

public enum XmlNodeType implements NodeType
{
    DOCTYPE(new NodeSign("<!DOCTYPE ", null), new NodeSign(null, ">"), false, true, false),
    CDATA(new NodeSign("<![CDATA[", null), new NodeSign(null, "]]>"), false, true, false),
    XML_DECLARATION(new NodeSign("<?xml", null), new NodeSign(null, "?>"), true, false, false),
    PROCESSING_INSTRUCTION(new NodeSign("<?", null), new NodeSign(null, "?>"), false, true, false),
    COMMENT(new NodeSign("<!--", null), new NodeSign(null, "-->"), false, true, false),
    ELEMENT(new NodeSign("<", ">"), new NodeSign("</", ">"), true, false, true),
    TEXT(null, null, false, true, false);

    private NodeType nt = null;

    private XmlNodeType(NodeSign head, NodeSign tail, boolean hasHeader, boolean hasContent, boolean hasBody) {
        this.nt = new NodeTypeImpl(head, tail, hasHeader, hasContent, hasBody);
    }

    public boolean isHasHeader() {
        return this.nt.isHasHeader();
    }

    public boolean isHasBody() {
        return this.nt.isHasBody();
    }

    public boolean isHasContent() {
        return this.nt.isHasContent();
    }

    public NodeSign getHead() {
        return this.nt.getHead();
    }

    public NodeSign getTail() {
        return this.nt.getTail();
    }

    public void getHeader(StringBuffer sb, String str) {
        if (this.equals((Object)ELEMENT) && str.length() == 0) {
            return;
        }
        if (this.getHead() == null) {
            sb.append(str);
        } else {
            if (this.getHead().getStart() != null) {
                sb.append(this.getHead().getStart());
            }
            sb.append(str);
            if (this.getHead().getEnd() != null) {
                sb.append(this.getHead().getEnd());
            }
        }
    }

    public void getTail(StringBuffer sb, String str) {
        if (this.equals((Object)ELEMENT) && str.length() == 0) {
            return;
        }
        if (this.getTail() == null) {
            sb.append(str);
        } else {
            if (this.getTail().getStart() != null) {
                sb.append(this.getTail().getStart());
            }
            sb.append(str);
            if (this.getTail().getEnd() != null) {
                sb.append(this.getTail().getEnd());
            }
        }
    }

    public boolean isText() {
        return this == TEXT;
    }
}

