/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.error;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Instantiate;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Requires;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wisdom.api.DefaultController;
import org.wisdom.api.http.Context;
import org.wisdom.api.http.Renderable;
import org.wisdom.api.http.Result;
import org.wisdom.api.http.Results;
import org.wisdom.api.interception.Filter;
import org.wisdom.api.interception.RequestContext;
import org.wisdom.api.router.Route;
import org.wisdom.api.router.Router;
import org.wisdom.api.templates.Template;

@Component
@Provides(specifications={Filter.class})
@Instantiate
public class DefaultPageErrorHandler
extends DefaultController
implements Filter,
Pojo {
    InstanceManager __IM;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"wisdom-error");
    public static final Pattern ALL_REQUESTS = Pattern.compile("/.*");
    private boolean __Fnoroute;
    @Requires(filter="(name=error/404)", proxy=false, optional=true, id="404")
    private Template noroute;
    private boolean __Finternalerror;
    @Requires(filter="(name=error/500)", proxy=false, optional=true, id="500")
    private Template internalerror;
    private boolean __Frouter;
    @Requires
    private Router router;
    boolean __MonError$org_wisdom_api_http_Context$org_wisdom_api_router_Route$java_lang_Throwable;
    boolean __Mcall$org_wisdom_api_router_Route$org_wisdom_api_interception_RequestContext;
    boolean __Muri;
    boolean __Mpriority;

    Template __getnoroute() {
        if (!this.__Fnoroute) {
            return this.noroute;
        }
        return (Template)this.__IM.onGet((Object)this, "noroute");
    }

    void __setnoroute(Template template) {
        if (!this.__Fnoroute) {
            this.noroute = template;
            return;
        }
        this.__IM.onSet((Object)this, "noroute", (Object)template);
    }

    Template __getinternalerror() {
        if (!this.__Finternalerror) {
            return this.internalerror;
        }
        return (Template)this.__IM.onGet((Object)this, "internalerror");
    }

    void __setinternalerror(Template template) {
        if (!this.__Finternalerror) {
            this.internalerror = template;
            return;
        }
        this.__IM.onSet((Object)this, "internalerror", (Object)template);
    }

    Router __getrouter() {
        if (!this.__Frouter) {
            return this.router;
        }
        return (Router)this.__IM.onGet((Object)this, "router");
    }

    void __setrouter(Router router) {
        if (!this.__Frouter) {
            this.router = router;
            return;
        }
        this.__IM.onSet((Object)this, "router", (Object)router);
    }

    public DefaultPageErrorHandler() {
        this(null);
    }

    private DefaultPageErrorHandler(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    private Result onError(Context context, Route route, Throwable e) {
        Result result;
        if (!this.__MonError$org_wisdom_api_http_Context$org_wisdom_api_router_Route$java_lang_Throwable) {
            return this.__M_onError(context, route, e);
        }
        try {
            this.__IM.onEntry((Object)this, "onError$org_wisdom_api_http_Context$org_wisdom_api_router_Route$java_lang_Throwable", new Object[]{context, route, e});
            result = this.__M_onError(context, route, e);
            this.__IM.onExit((Object)this, "onError$org_wisdom_api_http_Context$org_wisdom_api_router_Route$java_lang_Throwable", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "onError$org_wisdom_api_http_Context$org_wisdom_api_router_Route$java_lang_Throwable", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_onError(Context context, Route route, Throwable e) {
        StackTraceElement[] stack;
        String cause;
        Throwable localException = e;
        if (this.__getinternalerror() == null) {
            return DefaultPageErrorHandler.internalServerError((Throwable)e);
        }
        if (localException instanceof InvocationTargetException) {
            localException = ((InvocationTargetException)localException).getTargetException();
        }
        if (localException.getCause() != null) {
            cause = localException.getCause().getMessage();
            stack = localException.getCause().getStackTrace();
        } else {
            cause = localException.getMessage();
            stack = localException.getStackTrace();
        }
        String fileName = null;
        int line = -1;
        if (stack != null && stack.length != 0) {
            fileName = stack[0].getFileName();
            line = stack[0].getLineNumber();
        }
        List<StackTraceElement> cleaned = DefaultPageErrorHandler.cleanup(stack);
        return DefaultPageErrorHandler.internalServerError((Renderable)this.render(this.__getinternalerror(), new Object[]{"route", route, "context", context, "exception", localException, "message", localException.getMessage(), "cause", cause, "file", fileName, "line", line, "stack", cleaned}));
    }

    public static List<StackTraceElement> cleanup(StackTraceElement[] stack) {
        ArrayList<StackTraceElement> elements = new ArrayList<StackTraceElement>();
        if (stack == null) {
            return elements;
        }
        for (StackTraceElement element : stack) {
            if (element.getMethodName().startsWith("__M_")) {
                String newMethodName = element.getMethodName().substring("__M_".length());
                elements.add(new StackTraceElement(element.getClassName(), newMethodName, element.getFileName(), element.getLineNumber()));
                continue;
            }
            if (element.getLineNumber() < 0) continue;
            elements.add(element);
        }
        return elements;
    }

    public Result call(Route route, RequestContext context) throws Exception {
        Result result;
        if (!this.__Mcall$org_wisdom_api_router_Route$org_wisdom_api_interception_RequestContext) {
            return this.__M_call(route, context);
        }
        try {
            this.__IM.onEntry((Object)this, "call$org_wisdom_api_router_Route$org_wisdom_api_interception_RequestContext", new Object[]{route, context});
            result = this.__M_call(route, context);
            this.__IM.onExit((Object)this, "call$org_wisdom_api_router_Route$org_wisdom_api_interception_RequestContext", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "call$org_wisdom_api_router_Route$org_wisdom_api_interception_RequestContext", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_call(Route route, RequestContext context) throws Exception {
        try {
            Result result = context.proceed();
            if (result.getStatusCode() == 404) {
                if (this.__getnoroute() == null) {
                    return result;
                }
                return Results.notFound((Renderable)this.render(this.__getnoroute(), new Object[]{"method", route.getHttpMethod(), "uri", route.getUrl(), "routes", this.__getrouter().getRoutes()}));
            }
            return result;
        }
        catch (Exception e) {
            LOGGER.error("An exception occurred while processing request {} {}", new Object[]{route.getHttpMethod(), route.getUrl(), e});
            return this.onError(context.context(), route, e);
        }
    }

    public Pattern uri() {
        Pattern pattern;
        if (!this.__Muri) {
            return this.__M_uri();
        }
        try {
            this.__IM.onEntry((Object)this, "uri", new Object[0]);
            pattern = this.__M_uri();
            this.__IM.onExit((Object)this, "uri", (Object)pattern);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "uri", throwable);
            throw throwable;
        }
        return pattern;
    }

    private Pattern __M_uri() {
        return ALL_REQUESTS;
    }

    public int priority() {
        int n;
        if (!this.__Mpriority) {
            return this.__M_priority();
        }
        try {
            this.__IM.onEntry((Object)this, "priority", new Object[0]);
            n = this.__M_priority();
            this.__IM.onExit((Object)this, "priority", (Object)new Integer(n));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "priority", throwable);
            throw throwable;
        }
        return n;
    }

    private int __M_priority() {
        return 1000;
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("internalerror")) {
                this.__Finternalerror = true;
            }
            if (set.contains("noroute")) {
                this.__Fnoroute = true;
            }
            if (set.contains("router")) {
                this.__Frouter = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("onError$org_wisdom_api_http_Context$org_wisdom_api_router_Route$java_lang_Throwable")) {
                this.__MonError$org_wisdom_api_http_Context$org_wisdom_api_router_Route$java_lang_Throwable = true;
            }
            if (set.contains("call$org_wisdom_api_router_Route$org_wisdom_api_interception_RequestContext")) {
                this.__Mcall$org_wisdom_api_router_Route$org_wisdom_api_interception_RequestContext = true;
            }
            if (set.contains("uri")) {
                this.__Muri = true;
            }
            if (set.contains("priority")) {
                this.__Mpriority = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

