/*
 * Decompiled with CFR 0.152.
 */
package org.xmlobjects;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.atteo.classindex.ClassFilter;
import org.atteo.classindex.ClassIndex;
import org.w3c.dom.Element;
import org.xmlobjects.XMLObjectsException;
import org.xmlobjects.annotation.XMLElement;
import org.xmlobjects.annotation.XMLElements;
import org.xmlobjects.builder.ObjectBuildException;
import org.xmlobjects.builder.ObjectBuilder;
import org.xmlobjects.serializer.ObjectSerializeException;
import org.xmlobjects.serializer.ObjectSerializer;
import org.xmlobjects.stream.EventType;
import org.xmlobjects.stream.XMLReadException;
import org.xmlobjects.stream.XMLReader;
import org.xmlobjects.stream.XMLWriteException;
import org.xmlobjects.stream.XMLWriter;
import org.xmlobjects.xml.Namespaces;

public class XMLObjects {
    private final Map<String, Map<String, BuilderInfo>> builders = new ConcurrentHashMap<String, Map<String, BuilderInfo>>();
    private final Map<String, Map<String, ObjectSerializer<?>>> serializers = new ConcurrentHashMap();

    private XMLObjects() {
    }

    public static XMLObjects newInstance() throws XMLObjectsException {
        return XMLObjects.newInstance(Thread.currentThread().getContextClassLoader());
    }

    public static XMLObjects newInstance(ClassLoader classLoader) throws XMLObjectsException {
        XMLObjects context = new XMLObjects();
        context.loadBuilders(classLoader, true);
        context.loadSerializers(classLoader, true);
        return context;
    }

    public XMLObjects registerBuilder(ObjectBuilder<?> builder, String namespaceURI, String localName) throws XMLObjectsException {
        this.registerBuilder(builder, namespaceURI, localName, false);
        return this;
    }

    public ObjectBuilder<?> getBuilder(String namespaceURI, String localName) {
        BuilderInfo info = (BuilderInfo)this.builders.getOrDefault(namespaceURI, Collections.emptyMap()).get(localName);
        return info != null ? info.builder : null;
    }

    public <T> ObjectBuilder<T> getBuilder(String namespaceURI, String localName, Class<T> objectType) {
        Objects.requireNonNull(objectType, "Object type must not be null.");
        BuilderInfo info = (BuilderInfo)this.builders.getOrDefault(namespaceURI, Collections.emptyMap()).get(localName);
        return info != null && objectType.isAssignableFrom(info.objectType) ? info.builder : null;
    }

    public ObjectBuilder<?> getBuilder(String localName) {
        return this.getBuilder("", localName);
    }

    public <T> ObjectBuilder<T> getBuilder(String localName, Class<T> objectType) {
        return this.getBuilder("", localName, objectType);
    }

    public ObjectBuilder<?> getBuilder(QName name) {
        return this.getBuilder(name.getNamespaceURI(), name.getLocalPart());
    }

    public <T> ObjectBuilder<T> getBuilder(QName name, Class<T> objectType) {
        return this.getBuilder(name.getNamespaceURI(), name.getLocalPart(), objectType);
    }

    public Class<?> getObjectType(ObjectBuilder<?> builder) {
        for (Map<String, BuilderInfo> infos : this.builders.values()) {
            for (BuilderInfo info : infos.values()) {
                if (info.builder != builder) continue;
                return info.objectType;
            }
        }
        return Object.class;
    }

    public Class<?> getObjectType(String namespaceURI, ObjectBuilder<?> builder) {
        for (BuilderInfo info : this.builders.getOrDefault(namespaceURI, Collections.emptyMap()).values()) {
            if (info.builder != builder) continue;
            return info.objectType;
        }
        return Object.class;
    }

    public <T> XMLObjects registerSerializer(ObjectSerializer<T> serializer, Class<T> objectType, String namespaceURI) throws XMLObjectsException {
        this.registerSerializer(serializer, objectType, namespaceURI, false);
        return this;
    }

    public <T> ObjectSerializer<T> getSerializer(Class<T> objectType, String namespaceURI) {
        ObjectSerializer serializer = (ObjectSerializer)this.serializers.getOrDefault(objectType.getName(), Collections.emptyMap()).get(namespaceURI);
        return serializer != null ? serializer : null;
    }

    public <T> ObjectSerializer<T> getSerializer(Class<T> objectType) {
        return this.getSerializer(objectType, "");
    }

    public <T> ObjectSerializer<T> getSerializer(Class<T> objectType, Namespaces namespaces) {
        Map map = this.serializers.getOrDefault(objectType.getName(), Collections.emptyMap());
        for (Map.Entry entry : map.entrySet()) {
            if (!namespaces.contains((String)entry.getKey())) continue;
            return (ObjectSerializer)entry.getValue();
        }
        return null;
    }

    public Set<String> getSerializableNamespaces() {
        return this.serializers.values().stream().flatMap(map -> map.keySet().stream()).collect(Collectors.toSet());
    }

    public <T> T fromXML(XMLReader reader, Class<T> objectType) throws ObjectBuildException, XMLReadException {
        T object = null;
        int stopAt = 0;
        while (reader.hasNext()) {
            ObjectBuilder<T> builder;
            EventType event = reader.nextTag();
            if (event == EventType.START_ELEMENT && (builder = this.getBuilder(reader.getName(), objectType)) != null) {
                stopAt = reader.getDepth() - 2;
                object = reader.getObjectUsingBuilder(builder);
            }
            if (event != EventType.END_ELEMENT) continue;
            if (reader.getDepth() == stopAt) {
                return object;
            }
            if (reader.getDepth() >= stopAt) continue;
            throw new XMLReadException("XML reader is in an illegal state: depth = " + reader.getDepth() + " but expected depth = " + stopAt + ".");
        }
        return object;
    }

    public void toXML(XMLWriter writer, Object object, Namespaces namespaces) throws ObjectSerializeException, XMLWriteException {
        writer.writeStartDocument();
        writer.writeObject(object, namespaces);
        writer.writeEndDocument();
    }

    public void toXML(XMLWriter writer, Object object, Collection<String> namespaceURIs) throws ObjectSerializeException, XMLWriteException {
        this.toXML(writer, object, Namespaces.of(namespaceURIs));
    }

    public void toXML(XMLWriter writer, Object object, String ... namespaceURIs) throws ObjectSerializeException, XMLWriteException {
        this.toXML(writer, object, Namespaces.of(namespaceURIs));
    }

    public void toXML(XMLWriter writer, Object object) throws ObjectSerializeException, XMLWriteException {
        this.toXML(writer, object, Namespaces.of(this.getSerializableNamespaces()));
    }

    public void loadBuilders(ClassLoader classLoader, boolean failOnDuplicates) throws XMLObjectsException {
        for (Class type : ClassFilter.only().withoutModifiers(1024).satisfying(c -> c.isAnnotationPresent(XMLElement.class) || c.isAnnotationPresent(XMLElements.class)).from(ClassIndex.getSubclasses(ObjectBuilder.class, (ClassLoader)classLoader))) {
            ObjectBuilder builder;
            boolean isSetElement = type.isAnnotationPresent(XMLElement.class);
            boolean isSetElements = type.isAnnotationPresent(XMLElements.class);
            if (isSetElement && isSetElements) {
                throw new XMLObjectsException("The builder " + type.getName() + " uses both @XMLElement and @XMLElements.");
            }
            try {
                builder = (ObjectBuilder)type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new XMLObjectsException("The builder " + type.getName() + " lacks a default constructor.", e);
            }
            if (isSetElement) {
                XMLElement element = type.getAnnotation(XMLElement.class);
                this.registerBuilder(builder, element.namespaceURI(), element.name(), failOnDuplicates);
                continue;
            }
            if (!isSetElements) continue;
            XMLElements elements = type.getAnnotation(XMLElements.class);
            for (XMLElement element : elements.value()) {
                this.registerBuilder(builder, element.namespaceURI(), element.name(), failOnDuplicates);
            }
        }
    }

    public void loadSerializers(ClassLoader classLoader, boolean failOnDuplicates) throws XMLObjectsException {
        for (Class type : ClassFilter.only().withoutModifiers(1024).satisfying(c -> c.isAnnotationPresent(XMLElement.class) || c.isAnnotationPresent(XMLElements.class)).from(ClassIndex.getSubclasses(ObjectSerializer.class, (ClassLoader)classLoader))) {
            ObjectSerializer serializer;
            boolean isSetElement = type.isAnnotationPresent(XMLElement.class);
            boolean isSetElements = type.isAnnotationPresent(XMLElements.class);
            if (isSetElement && isSetElements) {
                throw new XMLObjectsException("The serializer " + type.getName() + " uses both @XMLElement and @XMLElements.");
            }
            try {
                serializer = (ObjectSerializer)type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new XMLObjectsException("The serializer " + type.getName() + " lacks a default constructor.", e);
            }
            Class<?> objectType = this.findObjectType(serializer);
            if (isSetElement) {
                XMLElement element = type.getAnnotation(XMLElement.class);
                this.registerSerializer(serializer, objectType, element.namespaceURI(), failOnDuplicates);
                continue;
            }
            if (!isSetElements) continue;
            XMLElements elements = type.getAnnotation(XMLElements.class);
            for (XMLElement element : elements.value()) {
                this.registerSerializer(serializer, objectType, element.namespaceURI(), failOnDuplicates);
            }
        }
    }

    public void unloadBuilders(String namespaceURI) {
        if (namespaceURI != null) {
            this.builders.remove(namespaceURI);
        }
    }

    public void unloadSerializers(String namespaceURI) {
        if (namespaceURI != null) {
            this.serializers.values().forEach(v -> v.remove(namespaceURI));
        }
    }

    private void registerBuilder(ObjectBuilder<?> builder, String namespaceURI, String localName, boolean failOnDuplicates) throws XMLObjectsException {
        BuilderInfo info = new BuilderInfo(builder, this.findObjectType(builder));
        BuilderInfo current = this.builders.computeIfAbsent(namespaceURI, v -> new HashMap()).put(localName, info);
        if (current != null && current.builder != builder && failOnDuplicates) {
            throw new XMLObjectsException("Two builders are registered for the XML element " + new QName(namespaceURI, localName) + ": " + builder.getClass().getName() + " and " + current.builder.getClass().getName() + ".");
        }
    }

    private void registerSerializer(ObjectSerializer<?> serializer, Class<?> objectType, String namespaceURI, boolean failOnDuplicates) throws XMLObjectsException {
        ObjectSerializer<?> current = this.serializers.computeIfAbsent(objectType.getName(), v -> new HashMap()).put(namespaceURI, serializer);
        if (current != null && current != serializer && failOnDuplicates) {
            throw new XMLObjectsException("Two serializers are registered for the object type " + objectType.getName() + ": " + serializer.getClass().getName() + " and " + current.getClass().getName() + ".");
        }
    }

    private Class<?> findObjectType(ObjectBuilder<?> builder) throws XMLObjectsException {
        try {
            return builder.getClass().getMethod("createObject", QName.class, Object.class).getReturnType();
        }
        catch (NoSuchMethodException e) {
            throw new XMLObjectsException("The builder " + builder.getClass().getName() + " lacks the createObject method.", e);
        }
    }

    private Class<?> findObjectType(ObjectSerializer<?> serializer) throws XMLObjectsException {
        Class<?> clazz = serializer.getClass();
        Class objectType = null;
        for (Method method : clazz.getDeclaredMethods()) {
            if (method.isSynthetic() || !Modifier.isPublic(method.getModifiers())) continue;
            Class candidateType = null;
            switch (method.getName()) {
                case "createElement": {
                    Type[] parameters = method.getGenericParameterTypes();
                    if (parameters.length != 2 || !(parameters[0] instanceof Class) || parameters[1] != Namespaces.class) break;
                    candidateType = (Class)parameters[0];
                    break;
                }
                case "initializeElement": {
                    Type[] parameters = method.getGenericParameterTypes();
                    if (parameters.length != 4 || parameters[0] != Element.class || !(parameters[1] instanceof Class) || parameters[2] != Namespaces.class || parameters[3] != XMLWriter.class) break;
                    candidateType = (Class)parameters[1];
                    break;
                }
                case "writeChildElements": {
                    Type[] parameters = method.getGenericParameterTypes();
                    if (parameters.length != 3 || !(parameters[0] instanceof Class) || parameters[1] != Namespaces.class || parameters[2] != XMLWriter.class) break;
                    candidateType = (Class)parameters[0];
                }
            }
            if (candidateType == null) continue;
            if (objectType != null && candidateType != objectType) {
                throw new XMLObjectsException("The serializer " + clazz.getName() + " uses different object types: " + objectType.getName() + " and " + candidateType.getName() + ".");
            }
            objectType = candidateType;
        }
        if (objectType == null) {
            throw new XMLObjectsException("The serializer " + clazz.getName() + " must implement at least one of the methods createElement, initializeElement, and writeChildElements.");
        }
        return objectType;
    }

    private static class BuilderInfo {
        final ObjectBuilder<?> builder;
        final Class<?> objectType;

        BuilderInfo(ObjectBuilder<?> builder, Class<?> objectType) {
            this.builder = builder;
            this.objectType = objectType;
        }
    }
}

