/*
 * Decompiled with CFR 0.152.
 */
package org.xmlobjects.schema;

import com.sun.xml.xsom.XSAnnotation;
import com.sun.xml.xsom.XSAttGroupDecl;
import com.sun.xml.xsom.XSAttributeDecl;
import com.sun.xml.xsom.XSAttributeUse;
import com.sun.xml.xsom.XSComplexType;
import com.sun.xml.xsom.XSContentType;
import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSFacet;
import com.sun.xml.xsom.XSIdentityConstraint;
import com.sun.xml.xsom.XSModelGroup;
import com.sun.xml.xsom.XSModelGroupDecl;
import com.sun.xml.xsom.XSNotation;
import com.sun.xml.xsom.XSParticle;
import com.sun.xml.xsom.XSSchema;
import com.sun.xml.xsom.XSSchemaSet;
import com.sun.xml.xsom.XSSimpleType;
import com.sun.xml.xsom.XSType;
import com.sun.xml.xsom.XSWildcard;
import com.sun.xml.xsom.XSXPath;
import com.sun.xml.xsom.visitor.XSVisitor;
import java.util.HashSet;
import java.util.Set;

public abstract class SchemaWalker
implements XSVisitor {
    private final Set<Object> visited = new HashSet<Object>();
    private boolean shouldWalk = true;

    public boolean shouldWalk() {
        return this.shouldWalk;
    }

    public void setShouldWalk(boolean shouldWalk) {
        this.shouldWalk = shouldWalk;
    }

    public void reset() {
        this.visited.clear();
        this.shouldWalk = true;
    }

    public void visit(XSSchema schema) {
        if (this.shouldWalk && this.visited.add(schema)) {
            this.schema(schema);
        }
    }

    public void visit(XSSchemaSet schemas) {
        for (XSSchema schema : schemas.getSchemas()) {
            if (!this.shouldWalk || !this.visited.add(schema)) continue;
            this.schema(schema);
        }
    }

    public void annotation(XSAnnotation ann) {
    }

    public void attGroupDecl(XSAttGroupDecl decl) {
        for (XSAttributeUse use : decl.getAttributeUses()) {
            if (!this.shouldWalk || !this.visited.add(use)) continue;
            this.attributeUse(use);
        }
    }

    public void attributeDecl(XSAttributeDecl decl) {
        if (this.shouldWalk && this.visited.add(decl.getType())) {
            this.simpleType(decl.getType());
        }
    }

    public void attributeUse(XSAttributeUse use) {
        if (this.shouldWalk && this.visited.add(use.getDecl())) {
            this.attributeDecl(use.getDecl());
        }
    }

    public void complexType(XSComplexType type) {
        if (this.shouldWalk && this.visited.add(type.getContentType())) {
            type.getContentType().visit((XSVisitor)this);
            for (XSAttributeUse use : type.getAttributeUses()) {
                if (!this.shouldWalk || !this.visited.add(use)) continue;
                this.attributeUse(use);
            }
        }
    }

    public void schema(XSSchema schema) {
        for (XSElementDecl decl : schema.getElementDecls().values()) {
            if (!this.shouldWalk || !this.visited.add(decl)) continue;
            this.elementDecl(decl);
        }
        for (XSElementDecl decl : schema.getAttributeDecls().values()) {
            if (!this.shouldWalk || !this.visited.add(decl)) continue;
            this.attributeDecl((XSAttributeDecl)decl);
        }
        for (XSElementDecl decl : schema.getAttGroupDecls().values()) {
            if (!this.shouldWalk || !this.visited.add(decl)) continue;
            this.attGroupDecl((XSAttGroupDecl)decl);
        }
        for (XSElementDecl decl : schema.getModelGroupDecls().values()) {
            if (!this.shouldWalk || !this.visited.add(decl)) continue;
            this.modelGroupDecl((XSModelGroupDecl)decl);
        }
        for (XSType type : schema.getTypes().values()) {
            if (!this.shouldWalk || !this.visited.add(type)) continue;
            type.visit((XSVisitor)this);
        }
        for (XSNotation notation : schema.getNotations().values()) {
            if (!this.shouldWalk || !this.visited.add(notation)) continue;
            this.notation(notation);
        }
    }

    public void facet(XSFacet facet) {
    }

    public void notation(XSNotation notation) {
    }

    public void identityConstraint(XSIdentityConstraint decl) {
    }

    public void xpath(XSXPath xp) {
    }

    public void simpleType(XSSimpleType simpleType) {
        if (this.shouldWalk && this.visited.add(simpleType.getBaseType())) {
            simpleType.getBaseType().visit((XSVisitor)this);
        }
    }

    public void particle(XSParticle particle) {
        if (this.shouldWalk && this.visited.add(particle.getTerm())) {
            particle.getTerm().visit((XSVisitor)this);
        }
    }

    public void empty(XSContentType empty) {
    }

    public void wildcard(XSWildcard wc) {
    }

    public void modelGroupDecl(XSModelGroupDecl decl) {
        if (this.shouldWalk && this.visited.add(decl.getModelGroup())) {
            this.modelGroup(decl.getModelGroup());
        }
    }

    public void modelGroup(XSModelGroup group) {
        for (XSParticle particle : group.getChildren()) {
            if (!this.shouldWalk || !this.visited.add(particle)) continue;
            this.particle(particle);
        }
    }

    public void elementDecl(XSElementDecl decl) {
        if (this.shouldWalk && this.visited.add(decl.getType())) {
            decl.getType().visit((XSVisitor)this);
        }
    }
}

