/*
 * Decompiled with CFR 0.152.
 */
package org.xmlobjects.util.composite;

import java.util.Objects;
import javax.xml.namespace.QName;
import org.xmlobjects.builder.ObjectBuildException;
import org.xmlobjects.builder.ObjectBuilder;
import org.xmlobjects.stream.XMLReadException;
import org.xmlobjects.stream.XMLReader;
import org.xmlobjects.xml.Attributes;

public abstract class CompositeObjectBuilder<T>
implements ObjectBuilder<T> {
    private final Class<? extends ObjectBuilder<T>> builder;

    public <S extends ObjectBuilder<? super T>> CompositeObjectBuilder(Class<S> adapter) {
        this.builder = Objects.requireNonNull(adapter, "Object builder must not be null.");
    }

    @Override
    public void initializeObject(T object, QName name, Attributes attributes, XMLReader reader) throws ObjectBuildException, XMLReadException {
        reader.getOrCreateBuilder(this.builder).initializeObject(object, name, attributes, reader);
    }

    @Override
    public void buildChildObject(T object, QName name, Attributes attributes, XMLReader reader) throws ObjectBuildException, XMLReadException {
        reader.getOrCreateBuilder(this.builder).buildChildObject(object, name, attributes, reader);
    }
}

