/*
 * Decompiled with CFR 0.152.
 */
package org.xmlobjects.util.copy;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.xmlobjects.util.copy.AbstractCloner;
import org.xmlobjects.util.copy.CopyBuilder;

public class ObjectCloner<T>
extends AbstractCloner<T> {
    private final List<Field> fields = new ArrayList<Field>();

    ObjectCloner(Class<?> type, CopyBuilder builder) {
        super(builder);
        do {
            Field[] fields;
            for (Field field : fields = type.getDeclaredFields()) {
                int modifiers = field.getModifiers();
                if (Modifier.isStatic(modifiers)) continue;
                field.setAccessible(true);
                this.fields.add(field);
            }
        } while ((type = type.getSuperclass()) != Object.class && type != null);
    }

    @Override
    public T copy(T src, T dest, boolean shallowCopy) throws Exception {
        if (shallowCopy) {
            for (Field field : this.fields) {
                field.set(dest, field.get(src));
            }
        } else {
            for (Field field : this.fields) {
                Object value = field.get(src);
                field.set(dest, this.deepCopy(value));
            }
        }
        return dest;
    }
}

