/*
 * Decompiled with CFR 0.152.
 */
package org.xmlobjects.util.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xmlobjects.util.xml.ArrayBuffer;
import org.xmlobjects.util.xml.NamespaceSupport;

public class SAXStreamReader
implements XMLStreamReader {
    private final ArrayBuffer.ArrayBufferIterator<Byte> events;
    private final ArrayBuffer.ArrayBufferIterator<String> strings;
    private final ArrayBuffer.ArrayBufferIterator<char[]> characters;
    private final ArrayBuffer<String> elements = new ArrayBuffer<String>(String.class, 512);
    private final NamespaceSupport prefixMapping = new NamespaceSupport();
    private final AttributesImpl attributes = new AttributesImpl();
    private final Namespaces namespaces = new Namespaces();
    private String localName;
    private String namespaceURI;
    private String prefix;
    private char[] chars;
    private int eventType = 7;

    SAXStreamReader(ArrayBuffer.ArrayBufferIterator<Byte> events, ArrayBuffer.ArrayBufferIterator<String> strings, ArrayBuffer.ArrayBufferIterator<char[]> characters) {
        this.events = events;
        this.strings = strings;
        this.characters = characters;
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        return null;
    }

    @Override
    public int next() throws XMLStreamException {
        switch (this.events.next()) {
            case 3: {
                this.eventType = 1;
                this.processStartElement();
                break;
            }
            case 4: {
                this.eventType = 2;
                this.processEndElement();
                break;
            }
            case 5: {
                this.eventType = 4;
                this.chars = this.characters.next();
                break;
            }
            case 1: {
                this.eventType = 7;
                break;
            }
            case 2: {
                this.eventType = 8;
                break;
            }
            case 6: {
                this.eventType = 13;
                this.processNamespace();
                break;
            }
            default: {
                throw new XMLStreamException("The SAX buffer is in an invalid state.");
            }
        }
        return this.eventType;
    }

    private void processNamespace() {
        String prefix = this.strings.next();
        String uri = this.strings.next();
        if (prefix == null) {
            prefix = "";
        }
        this.namespaces.add(prefix, uri);
        this.prefixMapping.pushContext();
        this.prefixMapping.declarePrefix(prefix, uri);
    }

    private void processStartElement() {
        this.prefixMapping.pushContext();
        this.namespaceURI = this.strings.next();
        this.localName = this.strings.next();
        String qName = this.strings.next();
        this.prefix = this.prefixMapping.getPrefix(this.namespaceURI);
        if (this.prefix == null) {
            this.prefix = this.prefixMapping.createPrefixFromQName(qName, this.namespaceURI);
            this.prefixMapping.declarePrefix(this.prefix, this.namespaceURI);
        }
        this.attributes.clear();
        while (this.events.hasNext() && this.events.peek() == 7) {
            this.events.next();
            String attributeURI = this.strings.next();
            String attributeLocalName = this.strings.next();
            String attributeQName = this.strings.next();
            String attributeType = this.strings.next();
            String attributeValue = this.strings.next();
            this.attributes.addAttribute(attributeURI != null ? attributeURI : "", attributeLocalName, !attributeQName.isEmpty() ? attributeQName : attributeLocalName, attributeType, attributeValue);
        }
        this.elements.push(this.namespaceURI);
        this.elements.push(this.localName);
        this.prefixMapping.requireNextContext();
    }

    private void processEndElement() {
        this.localName = this.elements.pop();
        this.namespaceURI = this.elements.pop();
        this.namespaces.clear();
        this.prefixMapping.popContext();
    }

    @Override
    public void require(int type, String namespaceURI, String localName) throws XMLStreamException {
        if (type != this.eventType) {
            throw new XMLStreamException("The specified event type " + type + " does not match the current parser event.");
        }
        if (namespaceURI != null && !namespaceURI.equals(this.getNamespaceURI())) {
            throw new XMLStreamException("The specified namespace URI " + namespaceURI + " does not match the current namespace URI.");
        }
        if (localName != null && !localName.equals(this.getLocalName())) {
            throw new XMLStreamException("The local name " + localName + " does not match the current local name.");
        }
    }

    @Override
    public String getElementText() throws XMLStreamException {
        if (this.eventType != 1) {
            throw new XMLStreamException("Illegal to call getElementText when event is not START_ELEMENT.");
        }
        StringBuilder content = new StringBuilder();
        this.next();
        while (this.eventType != 2) {
            if (this.eventType != 4) {
                throw new XMLStreamException("Element is not text-only.");
            }
            content.append(this.getText());
            this.next();
        }
        return content.toString();
    }

    @Override
    public int nextTag() throws XMLStreamException {
        this.next();
        while (this.eventType == 4 && this.isWhiteSpace()) {
            this.next();
        }
        if (this.eventType != 1 && this.eventType != 2) {
            throw new XMLStreamException("Expected START_ELEMENT or END_ELEMENT.");
        }
        return this.eventType;
    }

    @Override
    public boolean hasNext() throws XMLStreamException {
        return this.events.hasNext();
    }

    @Override
    public void close() throws XMLStreamException {
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("Prefix must not be null.");
        }
        return this.prefixMapping.getNamespaceURI(prefix);
    }

    @Override
    public boolean isStartElement() {
        return this.eventType == 1;
    }

    @Override
    public boolean isEndElement() {
        return this.eventType == 2;
    }

    @Override
    public boolean isCharacters() {
        return this.eventType == 4;
    }

    @Override
    public boolean isWhiteSpace() {
        if (this.eventType == 4) {
            for (char ch : this.chars) {
                if (Character.isWhitespace(ch)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public String getAttributeValue(String namespaceURI, String localName) {
        return null;
    }

    @Override
    public int getAttributeCount() {
        if (this.eventType != 1 && this.eventType != 10) {
            throw new IllegalStateException("Illegal to call getAttributeCount when event is neither START_ELEMENT nor ATTRIBUTE.");
        }
        return this.attributes.getLength();
    }

    @Override
    public QName getAttributeName(int index) {
        if (this.eventType != 1 && this.eventType != 10) {
            throw new IllegalStateException("Illegal to call getAttributeName when event is neither START_ELEMENT nor ATTRIBUTE.");
        }
        return new QName(this.attributes.getURI(index), this.attributes.getLocalName(index));
    }

    @Override
    public String getAttributeNamespace(int index) {
        if (this.eventType != 1 && this.eventType != 10) {
            throw new IllegalStateException("Illegal to call getAttributeNamespace when event is neither START_ELEMENT nor ATTRIBUTE.");
        }
        return this.attributes.getURI(index);
    }

    @Override
    public String getAttributeLocalName(int index) {
        if (this.eventType != 1 && this.eventType != 10) {
            throw new IllegalStateException("Illegal to call getAttributeLocalName when event is neither START_ELEMENT nor ATTRIBUTE.");
        }
        return this.attributes.getLocalName(index);
    }

    @Override
    public String getAttributePrefix(int index) {
        if (this.eventType != 1 && this.eventType != 10) {
            throw new IllegalStateException("Illegal to call getAttributePrefix when event is neither START_ELEMENT nor ATTRIBUTE.");
        }
        return this.prefixMapping.getPrefix(this.attributes.getURI(index));
    }

    @Override
    public String getAttributeType(int index) {
        if (this.eventType != 1 && this.eventType != 10) {
            throw new IllegalStateException("Illegal to call getAttributeType when event is neither START_ELEMENT nor ATTRIBUTE.");
        }
        return this.attributes.getType(index);
    }

    @Override
    public String getAttributeValue(int index) {
        if (this.eventType != 1 && this.eventType != 10) {
            throw new IllegalStateException("Illegal to call getAttributeValue when event is neither START_ELEMENT nor ATTRIBUTE.");
        }
        return this.attributes.getValue(index);
    }

    @Override
    public boolean isAttributeSpecified(int index) {
        if (this.eventType != 1 && this.eventType != 10) {
            throw new IllegalStateException("Illegal to call isAttributeSpecified when event is neither START_ELEMENT nor ATTRIBUTE.");
        }
        return true;
    }

    @Override
    public int getNamespaceCount() {
        if (this.eventType != 1 && this.eventType != 2 && this.eventType != 13) {
            throw new IllegalStateException("Illegal to call getNamespaceCount when event is neither START_ELEMENT nor ATTRIBUTE.");
        }
        return this.namespaces.size();
    }

    @Override
    public String getNamespacePrefix(int index) {
        if (this.eventType != 1 && this.eventType != 2 && this.eventType != 13) {
            throw new IllegalStateException("Illegal to call getNamespacePrefix when event is neither START_ELEMENT nor ATTRIBUTE.");
        }
        return this.namespaces.getPrefix(index);
    }

    @Override
    public String getNamespaceURI(int index) {
        if (this.eventType != 1 && this.eventType != 2 && this.eventType != 13) {
            throw new IllegalStateException("Illegal to call getNamespaceURI when event is neither START_ELEMENT nor ATTRIBUTE.");
        }
        return this.namespaces.getNamespaceURI(index);
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return new NamespaceContext(){

            @Override
            public String getNamespaceURI(String prefix) {
                String namespaceURI = SAXStreamReader.this.prefixMapping.getNamespaceURI(prefix);
                return namespaceURI != null ? namespaceURI : "";
            }

            @Override
            public String getPrefix(String namespaceURI) {
                if (namespaceURI == null) {
                    throw new IllegalArgumentException("Namespace URI must not be null.");
                }
                return SAXStreamReader.this.prefixMapping.getPrefix(namespaceURI);
            }

            @Override
            public Iterator<String> getPrefixes(String namespaceURI) {
                if (namespaceURI == null) {
                    throw new IllegalArgumentException("Namespace URI must not be null.");
                }
                return SAXStreamReader.this.prefixMapping.getPrefixes(namespaceURI).iterator();
            }
        };
    }

    @Override
    public int getEventType() {
        return this.eventType;
    }

    @Override
    public String getText() {
        if (this.eventType != 4) {
            throw new IllegalStateException("Illegal to call getText when event is not CHARACTERS.");
        }
        return String.valueOf(this.chars);
    }

    @Override
    public char[] getTextCharacters() {
        if (this.eventType != 4) {
            throw new IllegalStateException("Illegal to call getTextCharacters when event is not CHARACTERS.");
        }
        return this.chars;
    }

    @Override
    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) throws XMLStreamException {
        if (target == null) {
            throw new NullPointerException("Target char array must not be null.");
        }
        if (targetStart < 0 || length < 0 || sourceStart < 0 || targetStart >= target.length || targetStart + length > target.length) {
            throw new IndexOutOfBoundsException();
        }
        int copied = 0;
        int available = this.chars.length - sourceStart;
        if (available < 0) {
            throw new IndexOutOfBoundsException("sourceStart is greater than number of characters associated with this event.");
        }
        copied = Math.min(available, length);
        System.arraycopy(this.chars, sourceStart, target, targetStart, copied);
        return copied;
    }

    @Override
    public int getTextStart() {
        if (this.eventType != 4) {
            throw new IllegalStateException("Illegal to call getTextStart when event is not CHARACTERS.");
        }
        return 0;
    }

    @Override
    public int getTextLength() {
        if (this.eventType != 4) {
            throw new IllegalStateException("Illegal to call getTextLength when event is not CHARACTERS.");
        }
        return this.chars.length;
    }

    @Override
    public String getEncoding() {
        return null;
    }

    @Override
    public boolean hasText() {
        return this.eventType == 4;
    }

    @Override
    public Location getLocation() {
        return new Location(){

            @Override
            public int getLineNumber() {
                return -1;
            }

            @Override
            public int getColumnNumber() {
                return -1;
            }

            @Override
            public int getCharacterOffset() {
                return -1;
            }

            @Override
            public String getPublicId() {
                return null;
            }

            @Override
            public String getSystemId() {
                return null;
            }
        };
    }

    @Override
    public QName getName() {
        if (this.eventType != 1 && this.eventType != 2) {
            throw new IllegalStateException("Illegal to call getName when event is neither START_ELEMENT nor END_ELEMENT.");
        }
        return new QName(this.namespaceURI, this.localName);
    }

    @Override
    public String getLocalName() {
        if (this.eventType != 1 && this.eventType != 2) {
            throw new IllegalStateException("Illegal to call getLocalName when event is neither START_ELEMENT nor END_ELEMENT.");
        }
        return this.localName;
    }

    @Override
    public boolean hasName() {
        return this.eventType == 1 || this.eventType == 2;
    }

    @Override
    public String getNamespaceURI() {
        if (this.eventType == 1 || this.eventType == 2) {
            return this.namespaceURI;
        }
        return null;
    }

    @Override
    public String getPrefix() {
        if (this.eventType == 1 || this.eventType == 2) {
            return this.prefix;
        }
        return null;
    }

    @Override
    public String getVersion() {
        return "1.0";
    }

    @Override
    public boolean isStandalone() {
        return false;
    }

    @Override
    public boolean standaloneSet() {
        return false;
    }

    @Override
    public String getCharacterEncodingScheme() {
        return null;
    }

    @Override
    public String getPITarget() {
        return null;
    }

    @Override
    public String getPIData() {
        return null;
    }

    private static class Namespaces {
        private final List<String> prefixes = new ArrayList<String>();
        private final List<String> namespaceURIs = new ArrayList<String>();

        private Namespaces() {
        }

        void add(String prefix, String namespaceURI) {
            this.prefixes.add(prefix);
            this.namespaceURIs.add(namespaceURI);
        }

        String getPrefix(int index) {
            return this.prefixes.get(index);
        }

        String getNamespaceURI(int index) {
            return this.namespaceURIs.get(index);
        }

        int size() {
            return this.prefixes.size();
        }

        void clear() {
            this.prefixes.clear();
            this.namespaceURIs.clear();
        }
    }
}

