/*
 * Decompiled with CFR 0.152.
 */
package org.xmlobjects.stream;

import java.io.IOException;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stax.StAXSource;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import org.xmlobjects.XMLObjects;
import org.xmlobjects.builder.ObjectBuildException;
import org.xmlobjects.builder.ObjectBuilder;
import org.xmlobjects.schema.SchemaHandler;
import org.xmlobjects.stream.BuildResult;
import org.xmlobjects.stream.EventType;
import org.xmlobjects.stream.XMLReadException;
import org.xmlobjects.util.Properties;
import org.xmlobjects.util.xml.DepthXMLStreamReader;
import org.xmlobjects.util.xml.SAXWriter;
import org.xmlobjects.util.xml.StAXStream2SAX;
import org.xmlobjects.xml.Attributes;
import org.xmlobjects.xml.Namespaces;
import org.xmlobjects.xml.TextContent;

public class XMLReader
implements AutoCloseable {
    private final XMLObjects xmlObjects;
    private final DepthXMLStreamReader reader;
    private final Map<Class<?>, ObjectBuilder<?>> builderCache = new IdentityHashMap();
    private WeakReference<?> parent = new WeakReference<Object>(null);
    private boolean createDOMAsFallback;
    private Properties properties;
    private Transformer transformer;

    XMLReader(XMLObjects xmlObjects, XMLStreamReader reader, URI baseURI) {
        this.xmlObjects = Objects.requireNonNull(xmlObjects, "XML objects must not be null.");
        this.reader = new DepthXMLStreamReader(reader, baseURI);
    }

    XMLReader(XMLObjects xmlObjects, XMLStreamReader reader) {
        this(xmlObjects, reader, URI.create(""));
    }

    public XMLObjects getXMLObjects() {
        return this.xmlObjects;
    }

    public XMLStreamReader getStreamReader() {
        return this.reader;
    }

    public Namespaces getNamespaces() {
        return this.reader.getNamespaces();
    }

    public SchemaHandler getSchemaHandler() {
        return this.reader.getSchemaHandler();
    }

    void setSchemaHandler(SchemaHandler schemaHandler) {
        this.reader.setSchemaHandler(schemaHandler);
    }

    public String getEncoding() {
        return this.reader.getEncoding();
    }

    public boolean isCreateDOMAsFallback() {
        return this.createDOMAsFallback;
    }

    void createDOMAsFallback(boolean createDOMAsFallback) {
        this.createDOMAsFallback = createDOMAsFallback;
    }

    public URI getBaseURI() {
        return this.reader.getBaseURI();
    }

    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        return this.properties;
    }

    void setProperties(Properties properties) {
        this.properties = new Properties(properties);
    }

    @Override
    public void close() throws XMLReadException {
        try {
            this.reader.close();
        }
        catch (XMLStreamException e) {
            throw new XMLReadException("Caused by:", e);
        }
        finally {
            this.parent.clear();
            this.builderCache.clear();
        }
    }

    public int getDepth() {
        return this.reader.getDepth();
    }

    public boolean hasNext() throws XMLReadException {
        try {
            return this.reader.hasNext();
        }
        catch (XMLStreamException e) {
            throw new XMLReadException("Caused by:", e);
        }
    }

    public EventType nextTag() throws XMLReadException {
        try {
            do {
                int event = this.reader.next();
                switch (event) {
                    case 1: {
                        return EventType.START_ELEMENT;
                    }
                    case 2: {
                        return EventType.END_ELEMENT;
                    }
                }
            } while (this.reader.hasNext());
            return EventType.END_DOCUMENT;
        }
        catch (XMLStreamException e) {
            throw new XMLReadException("Caused by:", e);
        }
    }

    public QName getName() throws XMLReadException {
        if (this.reader.getEventType() != 1 && this.reader.getEventType() != 2) {
            throw new XMLReadException("Illegal to call getName when event is neither START_ELEMENT nor END_ELEMENT.");
        }
        return this.reader.getName();
    }

    public String getPrefix() throws XMLReadException {
        if (this.reader.getEventType() != 1 && this.reader.getEventType() != 2) {
            throw new XMLReadException("Illegal to call getPrefix when event is neither START_ELEMENT nor END_ELEMENT.");
        }
        return this.reader.getPrefix();
    }

    public <T> T getObject(Class<T> type) throws ObjectBuildException, XMLReadException {
        if (this.reader.getEventType() != 1) {
            throw new XMLReadException("Illegal to call getObject when event is not START_ELEMENT.");
        }
        QName name = this.reader.getName();
        ObjectBuilder<T> builder = this.xmlObjects.getBuilder(name, type);
        if (builder != null) {
            T object = builder.createObject(name, this.parent.get());
            if (object == null) {
                throw new ObjectBuildException("The builder " + builder.getClass().getName() + " created a null value.");
            }
            return this.processObject(object, name, builder);
        }
        return null;
    }

    public <T> T getObjectUsingBuilder(Class<? extends ObjectBuilder<T>> type) throws ObjectBuildException, XMLReadException {
        return this.getObjectUsingBuilder(this.getOrCreateBuilder(type));
    }

    public <T> T getObjectUsingBuilder(ObjectBuilder<T> builder) throws ObjectBuildException, XMLReadException {
        if (this.reader.getEventType() != 1) {
            throw new XMLReadException("Illegal to call getObjectUsingBuilder when event is not START_ELEMENT.");
        }
        QName name = this.reader.getName();
        T object = builder.createObject(name, this.parent.get());
        if (object == null) {
            throw new ObjectBuildException("The builder " + builder.getClass().getName() + " created a null value.");
        }
        return this.processObject(object, name, builder);
    }

    public <T> T fillObject(T object) throws ObjectBuildException, XMLReadException {
        if (object == null) {
            throw new ObjectBuildException("Illegal to call fillObject with a null object.");
        }
        if (this.reader.getEventType() != 1) {
            throw new XMLReadException("Illegal to call fillObject when event is not START_ELEMENT.");
        }
        QName name = this.reader.getName();
        ObjectBuilder<?> builder = this.xmlObjects.getBuilder(name, object.getClass());
        return builder != null ? (T)this.processObject(object, name, builder) : null;
    }

    public <T> T fillObjectUsingBuilder(T object, Class<? extends ObjectBuilder<T>> type) throws ObjectBuildException, XMLReadException {
        return this.fillObjectUsingBuilder(object, this.getOrCreateBuilder(type));
    }

    public <T> T fillObjectUsingBuilder(T object, ObjectBuilder<T> builder) throws ObjectBuildException, XMLReadException {
        if (object == null) {
            throw new ObjectBuildException("Illegal to call fillObjectUsingBuilder with a null object.");
        }
        if (this.reader.getEventType() != 1) {
            throw new XMLReadException("Illegal to call fillObjectUsingBuilder when event is not START_ELEMENT.");
        }
        return this.processObject(object, this.reader.getName(), builder);
    }

    private <T> T processObject(T object, QName name, ObjectBuilder<T> builder) throws ObjectBuildException, XMLReadException {
        WeakReference<?> previous = this.parent;
        try {
            this.parent = new WeakReference<T>(object);
            int stopAt = this.reader.getDepth() - 1;
            int childLevel = this.reader.getDepth() + 1;
            builder.initializeObject(object, name, this.getAttributes(), this);
            while (true) {
                if (this.reader.getEventType() == 1 && this.reader.getDepth() == childLevel) {
                    int state = this.reader.getState();
                    builder.buildChildObject(object, this.reader.getName(), this.getAttributes(), this);
                    if (this.reader.getEventType() == 1 && state != this.reader.getState()) continue;
                }
                if (this.reader.getEventType() == 2) {
                    if (this.reader.getDepth() == stopAt) {
                        T t = object;
                        return t;
                    }
                    if (this.reader.getDepth() < stopAt) {
                        throw new XMLReadException("Reader is in illegal state (depth = " + stopAt + " but expected depth = " + this.reader.getDepth() + ").");
                    }
                }
                if (!this.reader.hasNext()) break;
                this.reader.next();
            }
            T t = null;
            return t;
        }
        catch (XMLStreamException e) {
            throw new XMLReadException("Caused by:", e);
        }
        finally {
            this.parent = previous;
        }
    }

    public Element getDOMElement() throws XMLReadException {
        if (this.reader.getEventType() != 1) {
            throw new XMLReadException("Illegal to call getDOMElement when event is not START_ELEMENT.");
        }
        try {
            Node child;
            if (this.transformer == null) {
                this.transformer = TransformerFactory.newDefaultInstance().newTransformer();
            }
            DOMResult result = new DOMResult();
            this.transformer.transform(new StAXSource(this.reader), result);
            Node node = result.getNode();
            if (node.hasChildNodes() && (child = node.getFirstChild()).getNodeType() == 1) {
                Element element = (Element)child;
                return element;
            }
            Element element = null;
            return element;
        }
        catch (TransformerConfigurationException e) {
            throw new XMLReadException("Failed to initialize DOM transformer.", e);
        }
        catch (TransformerException e) {
            throw new XMLReadException("Failed to read XML content as DOM element.", e);
        }
        finally {
            if (this.transformer != null) {
                this.transformer.reset();
            }
        }
    }

    public <T> BuildResult<T> getObjectOrDOMElement(Class<T> type) throws ObjectBuildException, XMLReadException {
        Element element;
        T object = this.getObject(type);
        if (object != null) {
            return BuildResult.of(object);
        }
        if (this.createDOMAsFallback && (element = this.getDOMElement()) != null) {
            return BuildResult.of(element);
        }
        return BuildResult.empty();
    }

    public Attributes getAttributes() throws XMLReadException {
        if (this.reader.getEventType() != 1) {
            throw new XMLReadException("Illegal to call getAttributes when event is not START_ELEMENT.");
        }
        Attributes attributes = new Attributes();
        for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
            attributes.add(this.reader.getAttributeName(i), this.reader.getAttributeValue(i));
        }
        return attributes;
    }

    public TextContent getTextContent() throws XMLReadException {
        try {
            StringBuilder result = new StringBuilder();
            boolean shouldParse = true;
            while (shouldParse && this.reader.hasNext()) {
                int eventType = this.reader.next();
                switch (eventType) {
                    case 4: 
                    case 12: {
                        result.append(this.reader.getText());
                        break;
                    }
                    case 1: 
                    case 2: {
                        shouldParse = false;
                    }
                }
            }
            return TextContent.of(result.toString());
        }
        catch (XMLStreamException e) {
            throw new XMLReadException("Caused by:", e);
        }
    }

    public String getMixedContent() throws XMLReadException {
        String string;
        if (this.reader.getEventType() != 1) {
            throw new XMLReadException("Illegal to call getMixedContent when event is not START_ELEMENT.");
        }
        StringWriter writer = new StringWriter();
        try {
            try (SAXWriter saxWriter = (SAXWriter)new SAXWriter(writer).writeXMLDeclaration(false);){
                int stopAt = this.reader.getDepth() - 1;
                StAXStream2SAX mapper = new StAXStream2SAX(saxWriter);
                while (this.reader.next() != 2 || this.reader.getDepth() > stopAt) {
                    mapper.bridgeEvent(this.reader);
                }
            }
            string = writer.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | XMLStreamException | SAXException e) {
                throw new XMLReadException("Caused by:", e);
            }
        }
        writer.close();
        return string;
    }

    public <T> ObjectBuilder<T> getOrCreateBuilder(Class<? extends ObjectBuilder<T>> type) throws ObjectBuildException {
        ObjectBuilder<?> cachedBuilder = this.builderCache.get(type);
        if (cachedBuilder != null && type.isAssignableFrom(cachedBuilder.getClass())) {
            return type.cast(cachedBuilder);
        }
        try {
            ObjectBuilder<T> builder = type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.builderCache.put(type, builder);
            return builder;
        }
        catch (Exception e) {
            throw new ObjectBuildException("The builder " + type.getName() + " lacks a default constructor.");
        }
    }
}

