/*
 * Decompiled with CFR 0.152.
 */
package org.xmlobjects.util.copy;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.xmlobjects.util.copy.AbstractCloner;
import org.xmlobjects.util.copy.CopyBuilder;
import org.xmlobjects.util.copy.CopyException;

public class CollectionCloner<T extends Collection>
extends AbstractCloner<T> {
    CollectionCloner(CopyBuilder builder) {
        super(builder);
    }

    @Override
    public T copy(T src, T dest, boolean shallowCopy) {
        if (shallowCopy) {
            dest.addAll(src);
        } else {
            for (Object value : src) {
                dest.add(this.deepCopy(value));
            }
        }
        return dest;
    }

    @Override
    public T newInstance(T object, boolean shallowCopy) {
        try {
            return (T)((Collection)super.newInstance(object, shallowCopy));
        }
        catch (Throwable throwable) {
            if (object instanceof List) {
                return (T)new ArrayList(object.size());
            }
            if (object instanceof Set) {
                return (T)new HashSet(object.size());
            }
            if (object instanceof Deque) {
                return (T)new ArrayDeque(object.size());
            }
            throw new CopyException("Failed to create an instance of " + object.getClass() + ".");
        }
    }
}

