/*
 * Decompiled with CFR 0.152.
 */
package org.xmlobjects.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.UnaryOperator;
import org.xmlobjects.model.Child;

public class ChildList<T extends Child>
extends ArrayList<T> {
    private Child parent;

    public ChildList(Child parent) {
        this.parent = parent;
    }

    public ChildList(Collection<? extends T> c, Child parent) {
        super(c);
        this.parent = parent;
        this.applyParent(c);
    }

    public ChildList(int initialCapacity, Child parent) {
        super(initialCapacity);
        this.parent = parent;
    }

    public Child getParent() {
        return this.parent;
    }

    public void setParent(Child parent) {
        this.parent = parent;
        this.applyParent(this);
    }

    @Override
    public void add(int index, T element) {
        this.applyParent(element);
        super.add(index, element);
    }

    @Override
    public boolean add(T o) {
        this.applyParent(o);
        return super.add(o);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        this.applyParent(c);
        return super.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        this.applyParent(c);
        return super.addAll(index, c);
    }

    @Override
    public T set(int index, T element) {
        this.applyParent(element);
        return (T)((Child)super.set(index, element));
    }

    @Override
    public void replaceAll(UnaryOperator<T> operator) {
        super.replaceAll(operator);
        this.applyParent(this);
    }

    private void applyParent(T child) {
        if (child != null) {
            child.setParent(this.parent);
        }
    }

    private void applyParent(Collection<? extends T> c) {
        for (Child child : c) {
            if (child == null) continue;
            child.setParent(this.parent);
        }
    }
}

