/*
 * Decompiled with CFR 0.152.
 */
package org.xmlobjects.stream;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import org.xmlobjects.XMLObjects;
import org.xmlobjects.schema.SchemaHandler;
import org.xmlobjects.stream.XMLReadException;
import org.xmlobjects.stream.XMLReader;
import org.xmlobjects.util.Properties;
import org.xmlobjects.util.SystemIDResolver;
import org.xmlobjects.util.xml.SecureXMLProcessors;

public class XMLReaderFactory {
    private final XMLObjects xmlObjects;
    private final XMLInputFactory xmlInputFactory;
    private final Properties properties = new Properties();
    private SchemaHandler schemaHandler;
    private boolean createDOMAsFallback;

    private XMLReaderFactory(XMLObjects xmlObjects, XMLInputFactory xmlInputFactory) {
        this.xmlObjects = Objects.requireNonNull(xmlObjects, "XML objects must not be null.");
        this.xmlInputFactory = Objects.requireNonNull(xmlInputFactory, "XML input factory must not be null.");
        xmlInputFactory.setProperty("javax.xml.stream.isNamespaceAware", true);
    }

    public static XMLReaderFactory newInstance(XMLObjects xmlObjects, XMLInputFactory xmlInputFactory) throws XMLReadException {
        try {
            return new XMLReaderFactory(xmlObjects, xmlInputFactory);
        }
        catch (Throwable e) {
            throw new XMLReadException("Failed to initialize XML reader factory.", e);
        }
    }

    public static XMLReaderFactory newInstance(XMLObjects xmlObjects) throws XMLReadException {
        return XMLReaderFactory.newInstance(xmlObjects, SecureXMLProcessors.newXMLInputFactory());
    }

    public static XMLReaderFactory newDefaultInstance(XMLObjects xmlObjects) throws XMLReadException {
        return XMLReaderFactory.newInstance(xmlObjects, SecureXMLProcessors.newDefaultXMLInputFactory());
    }

    public SchemaHandler getSchemaHandler() {
        return this.schemaHandler;
    }

    public XMLReaderFactory withSchemaHandler(SchemaHandler schemaHandler) {
        this.schemaHandler = schemaHandler;
        return this;
    }

    public boolean isCreateDOMAsFallback() {
        return this.createDOMAsFallback;
    }

    public XMLReaderFactory createDOMAsFallback(boolean createDOMAsFallback) {
        this.createDOMAsFallback = createDOMAsFallback;
        return this;
    }

    public XMLReporter getXMLReporter() {
        return this.xmlInputFactory.getXMLReporter();
    }

    public XMLReaderFactory withXMLReporter(XMLReporter reporter) {
        this.xmlInputFactory.setXMLReporter(reporter);
        return this;
    }

    public XMLResolver getXMLResolver() {
        return this.xmlInputFactory.getXMLResolver();
    }

    public XMLReaderFactory withXMLResolver(XMLResolver resolver) {
        this.xmlInputFactory.setXMLResolver(resolver);
        return this;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public XMLReaderFactory withProperty(String name, Object value) {
        this.properties.set(name, value);
        return this;
    }

    public XMLReader createReader(File file) throws XMLReadException {
        try {
            return this.createReader(this.xmlInputFactory.createXMLStreamReader(new BufferedInputStream(new FileInputStream(file))), file.toURI().normalize());
        }
        catch (FileNotFoundException | XMLStreamException e) {
            throw new XMLReadException("Caused by:", e);
        }
    }

    public XMLReader createReader(File file, String encoding) throws XMLReadException {
        try {
            return this.createReader(this.xmlInputFactory.createXMLStreamReader(new BufferedInputStream(new FileInputStream(file)), encoding), file.toURI().normalize());
        }
        catch (FileNotFoundException | XMLStreamException e) {
            throw new XMLReadException("Caused by:", e);
        }
    }

    public XMLReader createReader(Path path) throws XMLReadException {
        try {
            return this.createReader(this.xmlInputFactory.createXMLStreamReader(new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]))), path.toUri().normalize());
        }
        catch (IOException | XMLStreamException e) {
            throw new XMLReadException("Caused by:", e);
        }
    }

    public XMLReader createReader(Path path, String encoding) throws XMLReadException {
        try {
            return this.createReader(this.xmlInputFactory.createXMLStreamReader(new BufferedInputStream(Files.newInputStream(path, new OpenOption[0])), encoding), path.toUri().normalize());
        }
        catch (IOException | XMLStreamException e) {
            throw new XMLReadException("Caused by:", e);
        }
    }

    public XMLReader createReader(InputStream stream) throws XMLReadException {
        try {
            return this.createReader(this.xmlInputFactory.createXMLStreamReader(stream));
        }
        catch (XMLStreamException e) {
            throw new XMLReadException("Caused by:", e);
        }
    }

    public XMLReader createReader(InputStream stream, String encoding) throws XMLReadException {
        try {
            return this.createReader(this.xmlInputFactory.createXMLStreamReader(stream, encoding));
        }
        catch (XMLStreamException e) {
            throw new XMLReadException("Caused by:", e);
        }
    }

    public XMLReader createReader(String systemId, InputStream stream) throws XMLReadException {
        try {
            return this.createReader(this.xmlInputFactory.createXMLStreamReader(systemId, stream), this.createBaseURI(systemId));
        }
        catch (XMLStreamException e) {
            throw new XMLReadException("Caused by:", e);
        }
    }

    public XMLReader createReader(String systemId, InputStream stream, String encoding) throws XMLReadException {
        try {
            return this.createReader(this.xmlInputFactory.createXMLStreamReader(stream, encoding), this.createBaseURI(systemId));
        }
        catch (XMLStreamException e) {
            throw new XMLReadException("Caused by:", e);
        }
    }

    public XMLReader createReader(Reader reader) throws XMLReadException {
        try {
            return this.createReader(this.xmlInputFactory.createXMLStreamReader(reader));
        }
        catch (XMLStreamException e) {
            throw new XMLReadException("Caused by:", e);
        }
    }

    public XMLReader createReader(String systemId, Reader reader) throws XMLReadException {
        try {
            return this.createReader(this.xmlInputFactory.createXMLStreamReader(systemId, reader), this.createBaseURI(systemId));
        }
        catch (XMLStreamException e) {
            throw new XMLReadException("Caused by:", e);
        }
    }

    public XMLReader createReader(Source source) throws XMLReadException {
        try {
            return this.createReader(this.xmlInputFactory.createXMLStreamReader(source), this.createBaseURI(source.getSystemId()));
        }
        catch (XMLStreamException e) {
            throw new XMLReadException("Caused by:", e);
        }
    }

    public XMLReader createReader(XMLStreamReader reader) {
        return this.createReader(reader, URI.create(""));
    }

    public XMLReader createReader(XMLStreamReader reader, URI baseURI) {
        XMLReader xmlReader = new XMLReader(this.xmlObjects, reader, baseURI);
        xmlReader.setSchemaHandler(this.schemaHandler);
        xmlReader.createDOMAsFallback(this.createDOMAsFallback);
        xmlReader.setProperties(this.properties);
        return xmlReader;
    }

    public XMLReader createFilteredReader(XMLReader reader, StreamFilter filter) throws XMLReadException {
        try {
            return this.createReader(this.xmlInputFactory.createFilteredReader(reader.getStreamReader(), filter), reader.getBaseURI());
        }
        catch (XMLStreamException e) {
            throw new XMLReadException("Caused by:", e);
        }
    }

    private URI createBaseURI(String systemId) {
        try {
            return new URI(SystemIDResolver.getAbsoluteURI(systemId)).normalize();
        }
        catch (Exception e) {
            return URI.create("");
        }
    }
}

