/*
 * Decompiled with CFR 0.152.
 */
package org.xmlobjects.util;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

public class Properties
implements Serializable {
    private Map<String, Object> properties;

    public Properties() {
    }

    public Properties(Properties other) {
        if (other.properties != null) {
            this.properties = new HashMap<String, Object>();
            this.properties.putAll(other.properties);
        }
    }

    public Object get(String name) {
        return this.properties != null ? this.properties.get(name) : null;
    }

    public <T> T get(String name, Class<T> type) {
        if (this.properties != null) {
            Object value = this.properties.get(name);
            return type.isInstance(value) ? (T)type.cast(value) : null;
        }
        return null;
    }

    public boolean getAndCompare(String name, Object expectedValue) {
        return Objects.equals(this.get(name), expectedValue);
    }

    public <T> T getOrDefault(String name, Class<T> type, Supplier<T> supplier) {
        T value = this.get(name, type);
        return value != null ? value : supplier.get();
    }

    public <T> T getOrSet(String name, Class<T> type, Supplier<T> supplier) {
        T value = this.get(name, type);
        if (value == null) {
            value = supplier.get();
            this.set(name, value);
        }
        return value;
    }

    public void set(String name, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        this.properties.put(name, value);
    }

    public void remove(String name) {
        if (this.properties != null) {
            this.properties.remove(name);
        }
    }

    public void clear() {
        if (this.properties != null) {
            this.properties.clear();
        }
    }
}

