/*
 * Decompiled with CFR 0.152.
 */
package org.xmlobjects.util.xml;

import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.xmlobjects.XMLObjects;

public class NamespaceSupport {
    private Context current = new Context();
    private Map<String, String> prefixes;
    private boolean nextContext = true;
    private int prefixCounter = 1;

    public NamespaceSupport() {
        this.current.prefixes.put("http://www.w3.org/XML/1998/namespace", "xml");
        this.current.namespaceURIs.put("xml", "http://www.w3.org/XML/1998/namespace");
        this.current.prefixes.put("http://www.w3.org/2000/xmlns/", "xmlns");
        this.current.namespaceURIs.put("xmlns", "http://www.w3.org/2000/xmlns/");
        this.current.prefixes.put("", "");
    }

    public void createInternalPrefixes(XMLObjects xmlObjects) {
        this.prefixes = new HashMap<String, String>();
        xmlObjects.getSerializableNamespaces().stream().sorted().forEach(n -> this.prefixes.put((String)n, "ns" + this.prefixCounter++));
    }

    public boolean requiresNextContext() {
        return this.nextContext;
    }

    public void requireNextContext() {
        this.nextContext = true;
    }

    public void pushContext() {
        if (this.nextContext) {
            this.current = new Context(this.current);
            this.nextContext = false;
        }
    }

    public void popContext() {
        this.current = this.current.previous;
        if (this.current == null) {
            throw new EmptyStackException();
        }
    }

    public void declarePrefix(String prefix, String namespaceURI) {
        if (!(prefix == null || namespaceURI == null || "xml".equals(prefix) || "xmlns".equals(prefix) || "http://www.w3.org/XML/1998/namespace".equals(namespaceURI) || "http://www.w3.org/2000/xmlns/".equals(namespaceURI) || "".equals(namespaceURI))) {
            this.current.prefixes.remove(this.current.namespaceURIs.get(prefix));
            this.current.namespaceURIs.remove(this.current.prefixes.get(namespaceURI));
            this.current.prefixes.put(namespaceURI, prefix);
            this.current.namespaceURIs.put(prefix, namespaceURI);
        }
    }

    public String getPrefix(String namespaceURI) {
        Context context = this.current;
        String prefix = null;
        while (context != null && (prefix = context.prefixes.get(namespaceURI)) == null) {
            context = context.previous;
        }
        return prefix;
    }

    public Set<String> getPrefixes(String namespaceURI) {
        Context context = this.current;
        LinkedHashSet<String> prefixes = new LinkedHashSet<String>();
        while (context != null) {
            String prefix = context.prefixes.get(namespaceURI);
            if (prefix != null) {
                prefixes.add(prefix);
            }
            context = context.previous;
        }
        return prefixes;
    }

    public String getNamespaceURI(String prefix) {
        Context context = this.current;
        String namespaceURI = null;
        while (context != null && (namespaceURI = context.namespaceURIs.get(prefix)) == null) {
            context = context.previous;
        }
        return namespaceURI;
    }

    public Map<String, String> getCurrentContext() {
        return new HashMap<String, String>(this.current.prefixes);
    }

    public String createPrefixFromQName(String qName, String namespaceURI) {
        int index;
        String prefix = null;
        if (!qName.isEmpty() && (index = qName.indexOf(58)) != -1) {
            String candidate = qName.substring(0, index);
            String previous = this.getNamespaceURI(candidate);
            if (previous == null) {
                prefix = candidate;
            } else if (previous.equals(namespaceURI)) {
                return candidate;
            }
        }
        return prefix != null ? prefix : this.createPrefix(namespaceURI);
    }

    public String createPrefix(String namespaceURI) {
        Object prefix;
        Object object = prefix = this.prefixes != null ? this.prefixes.get(namespaceURI) : null;
        while (prefix == null || this.getNamespaceURI((String)prefix) != null) {
            prefix = "ns" + this.prefixCounter++;
        }
        return prefix;
    }

    private static class Context {
        private final Map<String, String> prefixes = new HashMap<String, String>();
        private final Map<String, String> namespaceURIs = new HashMap<String, String>();
        private Context previous;

        Context() {
        }

        Context(Context previous) {
            this.previous = previous;
        }
    }
}

