/*
 * Decompiled with CFR 0.152.
 */
package org.xmlobjects.util.xml;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class SecureXMLProcessors {
    private SecureXMLProcessors() {
    }

    public static XMLInputFactory newXMLInputFactory() {
        return SecureXMLProcessors.secure(XMLInputFactory.newFactory());
    }

    public static XMLInputFactory newXMLInputFactory(String factoryClassName, ClassLoader loader) {
        return SecureXMLProcessors.secure(XMLInputFactory.newFactory(factoryClassName, loader));
    }

    public static XMLInputFactory newDefaultXMLInputFactory() {
        return SecureXMLProcessors.secure(XMLInputFactory.newDefaultFactory());
    }

    private static XMLInputFactory secure(XMLInputFactory factory) {
        factory.setProperty("javax.xml.stream.supportDTD", false);
        factory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        return factory;
    }

    public static SAXParserFactory newSAXParserFactory() throws SAXNotSupportedException, SAXNotRecognizedException, ParserConfigurationException {
        return SecureXMLProcessors.secure(SAXParserFactory.newInstance());
    }

    public static SAXParserFactory newSAXParserFactory(String factoryClassName, ClassLoader loader) throws SAXNotSupportedException, SAXNotRecognizedException, ParserConfigurationException {
        return SecureXMLProcessors.secure(SAXParserFactory.newInstance(factoryClassName, loader));
    }

    public static SAXParserFactory newDefaultSAXParserFactory() throws SAXNotSupportedException, SAXNotRecognizedException, ParserConfigurationException {
        return SecureXMLProcessors.secure(SAXParserFactory.newDefaultInstance());
    }

    private static SAXParserFactory secure(SAXParserFactory factory) throws SAXNotSupportedException, SAXNotRecognizedException, ParserConfigurationException {
        factory.setXIncludeAware(false);
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        return factory;
    }

    public static DocumentBuilderFactory newDocumentBuilderFactory() throws ParserConfigurationException {
        return SecureXMLProcessors.secure(DocumentBuilderFactory.newInstance());
    }

    public static DocumentBuilderFactory newDocumentBuilderFactory(String factoryClassName, ClassLoader loader) throws ParserConfigurationException {
        return SecureXMLProcessors.secure(DocumentBuilderFactory.newInstance(factoryClassName, loader));
    }

    public static DocumentBuilderFactory newDefaultDocumentBuilderFactory() throws ParserConfigurationException {
        return SecureXMLProcessors.secure(DocumentBuilderFactory.newDefaultInstance());
    }

    private static DocumentBuilderFactory secure(DocumentBuilderFactory factory) throws ParserConfigurationException {
        factory.setXIncludeAware(false);
        factory.setExpandEntityReferences(false);
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        return factory;
    }

    public static TransformerFactory newTransformerFactory() throws TransformerConfigurationException {
        return SecureXMLProcessors.secure(TransformerFactory.newInstance());
    }

    public static TransformerFactory newTransformerFactory(String factoryClassName, ClassLoader loader) throws TransformerConfigurationException {
        return SecureXMLProcessors.secure(TransformerFactory.newInstance(factoryClassName, loader));
    }

    public static TransformerFactory newDefaultTransformerFactory(String factoryClassName, ClassLoader loader) throws TransformerConfigurationException {
        return SecureXMLProcessors.secure(TransformerFactory.newDefaultInstance());
    }

    private static TransformerFactory secure(TransformerFactory factory) throws TransformerConfigurationException {
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        return factory;
    }
}

