/*
 * Decompiled with CFR 0.152.
 */
package org.xmlobjects.xml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.xml.namespace.QName;
import org.xmlobjects.xml.Attributes;
import org.xmlobjects.xml.ElementContent;
import org.xmlobjects.xml.TextContent;

public class Element {
    private final QName name;
    private Attributes attributes;
    private List<ElementContent> content;

    private Element(String namespaceURI, String localName) {
        Objects.requireNonNull(namespaceURI, "The namespace URI must not be null.");
        Objects.requireNonNull(localName, "The local name must not be null.");
        this.name = new QName(namespaceURI, localName);
    }

    public static Element of(String namespaceURI, String localName) {
        return new Element(namespaceURI, localName);
    }

    public static Element of(String localName) {
        return new Element("", localName);
    }

    public QName getName() {
        return this.name;
    }

    public Element addAttribute(String namespaceURI, String localName, TextContent value) {
        if (value != null && value.isPresent()) {
            if (this.attributes == null) {
                this.attributes = new Attributes();
            }
            this.attributes.add(namespaceURI, localName, value);
        }
        return this;
    }

    public Element addAttribute(String namespaceURI, String localName, String value) {
        return this.addAttribute(namespaceURI, localName, TextContent.of(value));
    }

    public Element addAttribute(String name, TextContent value) {
        return this.addAttribute("", name, value);
    }

    public Element addAttribute(String name, String value) {
        return this.addAttribute(name, TextContent.of(value));
    }

    public Element addAttribute(QName name, TextContent value) {
        return this.addAttribute(name.getNamespaceURI(), name.getLocalPart(), value);
    }

    public Element addAttribute(QName name, String value) {
        return this.addAttribute(name, TextContent.of(value));
    }

    public boolean hasAttributes() {
        return this.attributes != null && !this.attributes.isEmpty();
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public Element addChildElement(Element child) {
        return this.addContent(ElementContent.of(child));
    }

    public Element addTextContent(TextContent textContent) {
        return textContent != null && textContent.isPresent() ? this.addContent(ElementContent.of(textContent)) : this;
    }

    public Element addTextContent(String text) {
        return this.addTextContent(TextContent.of(text));
    }

    private Element addContent(ElementContent item) {
        if (item != null) {
            if (this.content == null) {
                this.content = new ArrayList<ElementContent>();
            }
            this.content.add(item);
        }
        return this;
    }

    public boolean hasContent() {
        return this.content != null && !this.content.isEmpty();
    }

    public List<ElementContent> getContent() {
        return this.content != null ? this.content : Collections.emptyList();
    }
}

