/*
 * Decompiled with CFR 0.152.
 */
package org.xmlobjects.xml;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;

public class TextContent {
    private static final DatatypeFactory XML_TYPE_FACTORY;
    private static final TextContent EMPTY;
    private static Function<LocalDateTime, ZoneOffset> ZONE_OFFSET_PROVIDER;
    private static boolean WITH_TIME_OFFSET;
    private static boolean WITH_DATE_OFFSET;
    private static final EnumSet<Fields> DATE_TIME_FIELDS;
    private static final EnumSet<Fields> TIME_FIELDS;
    private static final EnumSet<Fields> DATE_FIELDS;
    private static final EnumSet<Fields> GYEAR_MONTH_FIELDS;
    private static final EnumSet<Fields> GMONTH_DAY_FIELDS;
    private static final EnumSet<Fields> GDAY_FIELDS;
    private static final EnumSet<Fields> GMONTH_FIELDS;
    private static final EnumSet<Fields> GYEAR_FIELDS;
    private String content;
    private String trimmedContent;
    private String[] tokenizedContent;
    private Object value;
    private Function<LocalDateTime, ZoneOffset> zoneOffsetProvider = ZONE_OFFSET_PROVIDER;

    private TextContent(String content) {
        this.content = Objects.requireNonNull(content, "Content must not be null.");
    }

    public static TextContent empty() {
        return EMPTY;
    }

    public static TextContent of(String content) {
        return TextContent.ofObject(content);
    }

    public static TextContent ofList(List<String> content) {
        return TextContent.ofObjectList(content);
    }

    public static TextContent ofBoolean(Boolean content) {
        return TextContent.ofObject(content);
    }

    public static TextContent ofBooleanList(List<Boolean> content) {
        return TextContent.ofObjectList(content);
    }

    public static TextContent ofDouble(Double content) {
        return TextContent.ofObject(content);
    }

    public static TextContent ofDoubleList(List<Double> content) {
        return TextContent.ofObjectList(content);
    }

    public static TextContent ofInteger(Integer content) {
        return TextContent.ofObject(content);
    }

    public static TextContent ofIntegerList(List<Integer> content) {
        return TextContent.ofObjectList(content);
    }

    public static TextContent ofDuration(Duration content) {
        return TextContent.ofObject(content);
    }

    public static TextContent ofDurationList(List<Duration> content) {
        return TextContent.ofObjectList(content);
    }

    public static TextContent ofDateTime(OffsetDateTime content, boolean withOffset) {
        return TextContent.ofOffsetDateTime(content, DATE_TIME_FIELDS, withOffset);
    }

    public static TextContent ofDateTime(OffsetDateTime content) {
        return TextContent.ofOffsetDateTime(content, DATE_TIME_FIELDS, WITH_TIME_OFFSET);
    }

    public static TextContent ofDateTimeList(List<OffsetDateTime> content, boolean withOffset) {
        return TextContent.ofOffsetDateTimeList(content, DATE_TIME_FIELDS, withOffset);
    }

    public static TextContent ofDateTimeList(List<OffsetDateTime> content) {
        return TextContent.ofOffsetDateTimeList(content, DATE_TIME_FIELDS, WITH_TIME_OFFSET);
    }

    public static TextContent ofTime(OffsetDateTime content, boolean withOffset) {
        return TextContent.ofOffsetDateTime(content, TIME_FIELDS, withOffset);
    }

    public static TextContent ofTime(OffsetDateTime content) {
        return TextContent.ofOffsetDateTime(content, TIME_FIELDS, WITH_TIME_OFFSET);
    }

    public static TextContent ofTimeList(List<OffsetDateTime> content, boolean withOffset) {
        return TextContent.ofOffsetDateTimeList(content, TIME_FIELDS, withOffset);
    }

    public static TextContent ofTimeList(List<OffsetDateTime> content) {
        return TextContent.ofOffsetDateTimeList(content, TIME_FIELDS, WITH_TIME_OFFSET);
    }

    public static TextContent ofDate(OffsetDateTime content, boolean withOffset) {
        return TextContent.ofOffsetDateTime(content, DATE_FIELDS, withOffset);
    }

    public static TextContent ofDate(OffsetDateTime content) {
        return TextContent.ofOffsetDateTime(content, DATE_FIELDS, WITH_DATE_OFFSET);
    }

    public static TextContent ofDateList(List<OffsetDateTime> content, boolean withOffset) {
        return TextContent.ofOffsetDateTimeList(content, DATE_FIELDS, withOffset);
    }

    public static TextContent ofDateList(List<OffsetDateTime> content) {
        return TextContent.ofOffsetDateTimeList(content, DATE_FIELDS, WITH_DATE_OFFSET);
    }

    public static TextContent ofGYearMonth(OffsetDateTime content, boolean withOffset) {
        return TextContent.ofOffsetDateTime(content, GYEAR_MONTH_FIELDS, withOffset);
    }

    public static TextContent ofGYearMonth(OffsetDateTime content) {
        return TextContent.ofOffsetDateTime(content, GYEAR_MONTH_FIELDS, WITH_DATE_OFFSET);
    }

    public static TextContent ofGYearMonthList(List<OffsetDateTime> content, boolean withOffset) {
        return TextContent.ofOffsetDateTimeList(content, GYEAR_MONTH_FIELDS, withOffset);
    }

    public static TextContent ofGYearMonthList(List<OffsetDateTime> content) {
        return TextContent.ofOffsetDateTimeList(content, GYEAR_MONTH_FIELDS, WITH_DATE_OFFSET);
    }

    public static TextContent ofGMonthDay(OffsetDateTime content, boolean withOffset) {
        return TextContent.ofOffsetDateTime(content, GMONTH_DAY_FIELDS, withOffset);
    }

    public static TextContent ofGMonthDay(OffsetDateTime content) {
        return TextContent.ofOffsetDateTime(content, GMONTH_DAY_FIELDS, WITH_DATE_OFFSET);
    }

    public static TextContent ofGMonthDayList(List<OffsetDateTime> content, boolean withOffset) {
        return TextContent.ofOffsetDateTimeList(content, GMONTH_DAY_FIELDS, withOffset);
    }

    public static TextContent ofGMonthDayList(List<OffsetDateTime> content) {
        return TextContent.ofOffsetDateTimeList(content, GMONTH_DAY_FIELDS, WITH_DATE_OFFSET);
    }

    public static TextContent ofGDay(OffsetDateTime content, boolean withOffset) {
        return TextContent.ofOffsetDateTime(content, GDAY_FIELDS, withOffset);
    }

    public static TextContent ofGDay(OffsetDateTime content) {
        return TextContent.ofOffsetDateTime(content, GDAY_FIELDS, WITH_DATE_OFFSET);
    }

    public static TextContent ofGDayList(List<OffsetDateTime> content, boolean withOffset) {
        return TextContent.ofOffsetDateTimeList(content, GDAY_FIELDS, withOffset);
    }

    public static TextContent ofGDayList(List<OffsetDateTime> content) {
        return TextContent.ofOffsetDateTimeList(content, GDAY_FIELDS, WITH_DATE_OFFSET);
    }

    public static TextContent ofGMonth(OffsetDateTime content, boolean withOffset) {
        return TextContent.ofOffsetDateTime(content, GMONTH_FIELDS, withOffset);
    }

    public static TextContent ofGMonth(OffsetDateTime content) {
        return TextContent.ofOffsetDateTime(content, GMONTH_FIELDS, WITH_DATE_OFFSET);
    }

    public static TextContent ofGMonthList(List<OffsetDateTime> content, boolean withOffset) {
        return TextContent.ofOffsetDateTimeList(content, GMONTH_FIELDS, withOffset);
    }

    public static TextContent ofGMonthList(List<OffsetDateTime> content) {
        return TextContent.ofOffsetDateTimeList(content, GMONTH_FIELDS, WITH_DATE_OFFSET);
    }

    public static TextContent ofGYear(OffsetDateTime content, boolean withOffset) {
        return TextContent.ofOffsetDateTime(content, GYEAR_FIELDS, withOffset);
    }

    public static TextContent ofGYear(OffsetDateTime content) {
        return TextContent.ofOffsetDateTime(content, GYEAR_FIELDS, WITH_DATE_OFFSET);
    }

    public static TextContent ofGYearList(List<OffsetDateTime> content, boolean withOffset) {
        return TextContent.ofOffsetDateTimeList(content, GYEAR_FIELDS, withOffset);
    }

    public static TextContent ofGYearList(List<OffsetDateTime> content) {
        return TextContent.ofOffsetDateTimeList(content, GYEAR_FIELDS, WITH_DATE_OFFSET);
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    public TextContent trim() {
        this.content = this.trimmedContent();
        return this;
    }

    public TextContent normalize() {
        int length = this.content.length();
        if (length != 0) {
            StringBuilder normalized = new StringBuilder(length);
            for (int i = 0; i < length; ++i) {
                char ch = this.content.charAt(i);
                normalized.append(this.isWhiteSpace(ch) ? (char)' ' : (char)ch);
            }
            this.content = normalized.toString();
        }
        return this;
    }

    public TextContent collapse() {
        int length = this.content.length();
        if (length != 0) {
            int i;
            char ch = '\u0000';
            for (i = 0; i < length && this.isWhiteSpace(ch = this.content.charAt(i)); ++i) {
            }
            if (i != length) {
                StringBuilder collapsed = new StringBuilder(length - i).append(ch);
                boolean isWhiteSpace = false;
                ++i;
                while (i < length) {
                    ch = this.content.charAt(i);
                    if (this.isWhiteSpace(ch)) {
                        isWhiteSpace = true;
                    } else {
                        if (isWhiteSpace) {
                            collapsed.append(' ');
                            isWhiteSpace = false;
                        }
                        collapsed.append(ch);
                    }
                    ++i;
                }
                this.content = this.trimmedContent = collapsed.toString();
            } else {
                this.trimmedContent = "";
                this.content = "";
            }
        }
        return this;
    }

    public TextContent filter(Predicate<TextContent> predicate) {
        return predicate.test(this) ? this : EMPTY;
    }

    public String get() {
        return this.isPresent() ? this.content : null;
    }

    public boolean isPresent() {
        return this != EMPTY;
    }

    public void ifPresent(Consumer<String> action) {
        if (this.isPresent()) {
            action.accept(this.content);
        }
    }

    public List<String> getAsList() {
        if (this.isListOfType(this.value, String.class)) {
            return (List)this.value;
        }
        if (this.tokenizeContent() != 0) {
            ArrayList strings = new ArrayList(this.tokenizedContent.length);
            Collections.addAll(strings, this.tokenizedContent);
            return this.setValue(strings);
        }
        return this.setValue(null);
    }

    public boolean isList() {
        return this.getAsList() != null;
    }

    public void ifList(Consumer<List<String>> action) {
        List<String> value = this.getAsList();
        if (value != null) {
            action.accept(value);
        }
    }

    public Boolean getAsBoolean() {
        Boolean bool;
        Object object = this.value;
        return object instanceof Boolean ? (bool = (Boolean)object) : this.setValue(this.toBoolean(this.trimmedContent()));
    }

    public boolean isBoolean() {
        return this.getAsBoolean() != null;
    }

    public void ifBoolean(Consumer<Boolean> action) {
        Boolean value = this.getAsBoolean();
        if (value != null) {
            action.accept(value);
        }
    }

    public List<Boolean> getAsBooleanList() {
        if (this.isListOfType(this.value, Boolean.class)) {
            return (List)this.value;
        }
        if (this.tokenizeContent() != 0) {
            ArrayList<Boolean> booleans = new ArrayList<Boolean>(this.tokenizedContent.length);
            for (String token : this.tokenizedContent) {
                Boolean value = this.toBoolean(token);
                if (value == null) {
                    return this.setValue(null);
                }
                booleans.add(value);
            }
            return this.setValue(booleans);
        }
        return this.setValue(null);
    }

    public boolean isBooleanList() {
        return this.getAsBooleanList() != null;
    }

    public void ifBooleanList(Consumer<List<Boolean>> action) {
        List<Boolean> value = this.getAsBooleanList();
        if (value != null) {
            action.accept(value);
        }
    }

    public Double getAsDouble() {
        Object object = this.value;
        if (object instanceof Double) {
            Double doubleValue = (Double)object;
            return doubleValue;
        }
        if (!this.isEmpty() && !this.trimmedContent().isEmpty()) {
            try {
                return this.setValue(Double.parseDouble(this.trimmedContent));
            }
            catch (NumberFormatException e) {
                return this.setValue(null);
            }
        }
        return this.setValue(null);
    }

    public boolean isDouble() {
        return this.getAsDouble() != null;
    }

    public void ifDouble(Consumer<Double> action) {
        Double value = this.getAsDouble();
        if (value != null) {
            action.accept(value);
        }
    }

    public List<Double> getAsDoubleList() {
        if (this.isListOfType(this.value, Double.class)) {
            return (List)this.value;
        }
        if (this.tokenizeContent() != 0) {
            ArrayList<Double> doubles = new ArrayList<Double>(this.tokenizedContent.length);
            for (String token : this.tokenizedContent) {
                try {
                    doubles.add(Double.parseDouble(token));
                }
                catch (NumberFormatException e) {
                    return this.setValue(null);
                }
            }
            return this.setValue(doubles);
        }
        return this.setValue(null);
    }

    public boolean isDoubleList() {
        return this.getAsDoubleList() != null;
    }

    public void ifDoubleList(Consumer<List<Double>> action) {
        List<Double> value = this.getAsDoubleList();
        if (value != null) {
            action.accept(value);
        }
    }

    public Integer getAsInteger() {
        Object object = this.value;
        if (object instanceof Integer) {
            Integer intValue = (Integer)object;
            return intValue;
        }
        if (!this.isEmpty() && !this.trimmedContent().isEmpty()) {
            try {
                return this.setValue(Integer.parseInt(this.trimmedContent));
            }
            catch (NumberFormatException e) {
                return this.setValue(null);
            }
        }
        return this.setValue(null);
    }

    public boolean isInteger() {
        return this.getAsInteger() != null;
    }

    public void ifInteger(Consumer<Integer> action) {
        Integer value = this.getAsInteger();
        if (value != null) {
            action.accept(value);
        }
    }

    public List<Integer> getAsIntegerList() {
        if (this.isListOfType(this.value, Integer.class)) {
            return (List)this.value;
        }
        if (this.tokenizeContent() != 0) {
            ArrayList<Integer> integers = new ArrayList<Integer>(this.tokenizedContent.length);
            for (String token : this.tokenizedContent) {
                try {
                    integers.add(Integer.parseInt(token));
                }
                catch (NumberFormatException e) {
                    return this.setValue(null);
                }
            }
            return this.setValue(integers);
        }
        return this.setValue(null);
    }

    public boolean isIntegerList() {
        return this.getAsIntegerList() != null;
    }

    public void ifIntegerList(Consumer<List<Integer>> action) {
        List<Integer> value = this.getAsIntegerList();
        if (value != null) {
            action.accept(value);
        }
    }

    public Duration getAsDuration() {
        Object object = this.value;
        if (object instanceof Duration) {
            Duration duration = (Duration)object;
            return duration;
        }
        if (!this.isEmpty() && !this.trimmedContent().isEmpty()) {
            try {
                return this.setValue(XML_TYPE_FACTORY.newDuration(this.trimmedContent));
            }
            catch (Throwable e) {
                return this.setValue(null);
            }
        }
        return this.setValue(null);
    }

    public boolean isDuration() {
        return this.getAsDuration() != null;
    }

    public void ifDuration(Consumer<Duration> action) {
        Duration value = this.getAsDuration();
        if (value != null) {
            action.accept(value);
        }
    }

    public List<Duration> getAsDurationList() {
        if (this.isListOfType(this.value, Duration.class)) {
            return (List)this.value;
        }
        if (this.tokenizeContent() != 0) {
            ArrayList<Duration> durations = new ArrayList<Duration>(this.tokenizedContent.length);
            for (String token : this.tokenizedContent) {
                try {
                    durations.add(XML_TYPE_FACTORY.newDuration(token));
                }
                catch (Throwable e) {
                    return this.setValue(null);
                }
            }
            return this.setValue(durations);
        }
        return this.setValue(null);
    }

    public boolean isDurationList() {
        return this.getAsDurationList() != null;
    }

    public void ifDurationList(Consumer<List<Duration>> action) {
        List<Duration> value = this.getAsDurationList();
        if (value != null) {
            action.accept(value);
        }
    }

    public OffsetDateTime getAsDateTime() {
        return this.toOffsetDateTime(this.getAsCalender("dateTime"));
    }

    public boolean isDateTime() {
        return this.getAsCalender("dateTime") != null;
    }

    public void ifDateTime(Consumer<OffsetDateTime> action) {
        OffsetDateTime value = this.getAsDateTime();
        if (value != null) {
            action.accept(value);
        }
    }

    public List<OffsetDateTime> getAsDateTimeList() {
        return this.toOffsetDateTimeList(this.getAsCalenderList("dateTime"));
    }

    public boolean isDateTimeList() {
        return this.getAsCalenderList("dateTime") != null;
    }

    public void ifDateTimeList(Consumer<List<OffsetDateTime>> action) {
        List<OffsetDateTime> value = this.getAsDateTimeList();
        if (value != null) {
            action.accept(value);
        }
    }

    public OffsetDateTime getAsTime() {
        return this.toOffsetDateTime(this.getAsCalender("time"));
    }

    public boolean isTime() {
        return this.getAsCalender("time") != null;
    }

    public void ifTime(Consumer<OffsetDateTime> action) {
        OffsetDateTime value = this.getAsTime();
        if (value != null) {
            action.accept(value);
        }
    }

    public List<OffsetDateTime> getAsTimeList() {
        return this.toOffsetDateTimeList(this.getAsCalenderList("time"));
    }

    public boolean isTimeList() {
        return this.getAsCalenderList("time") != null;
    }

    public void ifTimeList(Consumer<List<OffsetDateTime>> action) {
        List<OffsetDateTime> value = this.getAsTimeList();
        if (value != null) {
            action.accept(value);
        }
    }

    public OffsetDateTime getAsDate() {
        return this.toOffsetDateTime(this.getAsCalender("date"));
    }

    public boolean isDate() {
        return this.getAsCalender("date") != null;
    }

    public void ifDate(Consumer<OffsetDateTime> action) {
        OffsetDateTime value = this.getAsDate();
        if (value != null) {
            action.accept(value);
        }
    }

    public List<OffsetDateTime> getAsDateList() {
        return this.toOffsetDateTimeList(this.getAsCalenderList("date"));
    }

    public boolean isDateList() {
        return this.getAsCalenderList("date") != null;
    }

    public void ifDateList(Consumer<List<OffsetDateTime>> action) {
        List<OffsetDateTime> value = this.getAsDateList();
        if (value != null) {
            action.accept(value);
        }
    }

    public OffsetDateTime getAsGYearMonth() {
        return this.toOffsetDateTime(this.getAsCalender("gYearMonth"));
    }

    public boolean isGYearMonth() {
        return this.getAsCalender("gYearMonth") != null;
    }

    public void ifGYearMonth(Consumer<OffsetDateTime> action) {
        OffsetDateTime value = this.getAsGYearMonth();
        if (value != null) {
            action.accept(value);
        }
    }

    public List<OffsetDateTime> getAsGYearMonthList() {
        return this.toOffsetDateTimeList(this.getAsCalenderList("gYearMonth"));
    }

    public boolean isGYearMonthList() {
        return this.getAsCalenderList("gYearMonth") != null;
    }

    public void ifGYearMonthList(Consumer<List<OffsetDateTime>> action) {
        List<OffsetDateTime> value = this.getAsGYearMonthList();
        if (value != null) {
            action.accept(value);
        }
    }

    public OffsetDateTime getAsGMonthDay() {
        return this.toOffsetDateTime(this.getAsCalender("gMonthDay"));
    }

    public boolean isGMonthDay() {
        return this.getAsCalender("gMonthDay") != null;
    }

    public void ifGMonthDay(Consumer<OffsetDateTime> action) {
        OffsetDateTime value = this.getAsGMonthDay();
        if (value != null) {
            action.accept(value);
        }
    }

    public List<OffsetDateTime> getAsGMonthDayList() {
        return this.toOffsetDateTimeList(this.getAsCalenderList("gMonthDay"));
    }

    public boolean isGMonthDayList() {
        return this.getAsCalenderList("gMonthDay") != null;
    }

    public void ifGMonthDayList(Consumer<List<OffsetDateTime>> action) {
        List<OffsetDateTime> value = this.getAsGMonthDayList();
        if (value != null) {
            action.accept(value);
        }
    }

    public OffsetDateTime getAsGDay() {
        return this.toOffsetDateTime(this.getAsCalender("gDay"));
    }

    public boolean isGDay() {
        return this.getAsCalender("gDay") != null;
    }

    public void ifGDay(Consumer<OffsetDateTime> action) {
        OffsetDateTime value = this.getAsGDay();
        if (value != null) {
            action.accept(value);
        }
    }

    public List<OffsetDateTime> getAsGDayList() {
        return this.toOffsetDateTimeList(this.getAsCalenderList("gDay"));
    }

    public boolean isGDayList() {
        return this.getAsCalenderList("gDay") != null;
    }

    public void ifGDayList(Consumer<List<OffsetDateTime>> action) {
        List<OffsetDateTime> value = this.getAsGDayList();
        if (value != null) {
            action.accept(value);
        }
    }

    public OffsetDateTime getAsGMonth() {
        return this.toOffsetDateTime(this.getAsCalender("gMonth"));
    }

    public boolean isGMonth() {
        return this.getAsCalender("gMonth") != null;
    }

    public void ifGMonth(Consumer<OffsetDateTime> action) {
        OffsetDateTime value = this.getAsGMonth();
        if (value != null) {
            action.accept(value);
        }
    }

    public List<OffsetDateTime> getAsGMonthList() {
        return this.toOffsetDateTimeList(this.getAsCalenderList("gMonth"));
    }

    public boolean isGMonthList() {
        return this.getAsCalenderList("gMonth") != null;
    }

    public void ifGMonthList(Consumer<List<OffsetDateTime>> action) {
        List<OffsetDateTime> value = this.getAsGMonthList();
        if (value != null) {
            action.accept(value);
        }
    }

    public OffsetDateTime getAsGYear() {
        return this.toOffsetDateTime(this.getAsCalender("gYear"));
    }

    public boolean isGYear() {
        return this.getAsCalender("gYear") != null;
    }

    public void ifGYear(Consumer<OffsetDateTime> action) {
        OffsetDateTime value = this.getAsGYear();
        if (value != null) {
            action.accept(value);
        }
    }

    public List<OffsetDateTime> getAsGYearList() {
        return this.toOffsetDateTimeList(this.getAsCalenderList("gYear"));
    }

    public boolean isGYearList() {
        return this.getAsCalenderList("gYear") != null;
    }

    public void ifGYearList(Consumer<List<OffsetDateTime>> action) {
        List<OffsetDateTime> value = this.getAsGYearList();
        if (value != null) {
            action.accept(value);
        }
    }

    public TextContent withZoneOffsetProvider(Function<LocalDateTime, ZoneOffset> zoneOffsetProvider) {
        if (zoneOffsetProvider != null) {
            this.zoneOffsetProvider = zoneOffsetProvider;
        }
        return this;
    }

    private <T> T setValue(T value) {
        this.value = value;
        return value;
    }

    private XMLGregorianCalendar getAsCalender(String localName) {
        XMLGregorianCalendar calendar;
        Object object = this.value;
        if (object instanceof XMLGregorianCalendar && (calendar = (XMLGregorianCalendar)object).getXMLSchemaType().getLocalPart().equals(localName)) {
            return calendar;
        }
        if (!this.isEmpty() && !this.trimmedContent().isEmpty()) {
            return this.setValue(this.toCalendar(this.trimmedContent(), localName));
        }
        return this.setValue(null);
    }

    private List<XMLGregorianCalendar> getAsCalenderList(String localName) {
        List list;
        String[] stringArray = this.value;
        if (stringArray instanceof List && (list = (List)stringArray).stream().allMatch(v -> {
            XMLGregorianCalendar calendar;
            return v instanceof XMLGregorianCalendar && (calendar = (XMLGregorianCalendar)v).getXMLSchemaType().getLocalPart().equals(localName);
        })) {
            return list;
        }
        if (this.tokenizeContent() != 0) {
            ArrayList<XMLGregorianCalendar> calendars = new ArrayList<XMLGregorianCalendar>(this.tokenizedContent.length);
            for (String token : this.tokenizedContent) {
                XMLGregorianCalendar value = this.toCalendar(token, localName);
                if (value == null) {
                    return this.setValue(null);
                }
                calendars.add(value);
            }
            return this.setValue(calendars);
        }
        return this.setValue(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isListOfType(Object value, Class<?> type) {
        if (!(value instanceof List)) return false;
        List list = (List)value;
        if (!list.stream().allMatch(type::isInstance)) return false;
        return true;
    }

    private Boolean toBoolean(String value) {
        if (value.isEmpty()) {
            return null;
        }
        if ("true".equals(value) || "1".equals(value)) {
            return Boolean.TRUE;
        }
        if ("false".equals(value) || "0".equals(value)) {
            return Boolean.FALSE;
        }
        return null;
    }

    private XMLGregorianCalendar toCalendar(String value, String localName) {
        try {
            XMLGregorianCalendar calendar = XML_TYPE_FACTORY.newXMLGregorianCalendar(value);
            if (calendar.getXMLSchemaType().getLocalPart().equals(localName)) {
                return calendar;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private OffsetDateTime toOffsetDateTime(XMLGregorianCalendar calendar) {
        if (calendar != null) {
            int day = calendar.getDay();
            int month = calendar.getMonth();
            int year = calendar.getYear();
            int hour = calendar.getHour();
            int minute = calendar.getMinute();
            int second = calendar.getSecond();
            int offset = calendar.getTimezone();
            BigDecimal fractional = calendar.getFractionalSecond();
            int nano = fractional != null ? (int)(fractional.doubleValue() * 1.0E9) : Integer.MIN_VALUE;
            LocalDateTime dateTime = LocalDateTime.of(year != Integer.MIN_VALUE ? year : 0, month != Integer.MIN_VALUE ? month : 1, day != Integer.MIN_VALUE ? day : 1, hour != Integer.MIN_VALUE ? hour : 0, minute != Integer.MIN_VALUE ? minute : 0, second != Integer.MIN_VALUE ? second : 0, nano != Integer.MIN_VALUE ? nano : 0);
            return OffsetDateTime.of(dateTime, offset != Integer.MIN_VALUE ? ZoneOffset.ofTotalSeconds(offset * 60) : this.zoneOffsetProvider.apply(dateTime));
        }
        return null;
    }

    private List<OffsetDateTime> toOffsetDateTimeList(List<XMLGregorianCalendar> calenders) {
        if (calenders != null) {
            ArrayList<OffsetDateTime> dateTimes = new ArrayList<OffsetDateTime>(calenders.size());
            calenders.stream().map(this::toOffsetDateTime).forEach(dateTimes::add);
            return dateTimes;
        }
        return null;
    }

    private static TextContent ofObject(Object content) {
        return content != null ? new TextContent(content.toString()) : EMPTY;
    }

    private static TextContent ofObjectList(List<?> content) {
        if (content != null && !content.isEmpty()) {
            StringBuilder builder = new StringBuilder(content.size());
            boolean first = true;
            for (Object object : content) {
                if (object == null) continue;
                if (!first) {
                    builder.append(" ");
                } else {
                    first = false;
                }
                builder.append(object);
            }
            return new TextContent(builder.toString());
        }
        return EMPTY;
    }

    private static TextContent ofOffsetDateTime(OffsetDateTime content, EnumSet<Fields> fields, boolean withOffset) {
        XMLGregorianCalendar calendar = TextContent.toCalendar(content, fields, withOffset);
        return calendar != null ? new TextContent(calendar.toXMLFormat()) : EMPTY;
    }

    private static TextContent ofOffsetDateTimeList(List<OffsetDateTime> content, EnumSet<Fields> fields, boolean withOffset) {
        if (content != null && !content.isEmpty()) {
            StringBuilder builder = new StringBuilder(content.size());
            boolean first = true;
            for (OffsetDateTime dateTime : content) {
                XMLGregorianCalendar calendar = TextContent.toCalendar(dateTime, fields, withOffset);
                if (calendar == null) continue;
                if (!first) {
                    builder.append(" ");
                } else {
                    first = false;
                }
                builder.append(calendar.toXMLFormat());
            }
            return new TextContent(builder.toString());
        }
        return EMPTY;
    }

    private static XMLGregorianCalendar toCalendar(OffsetDateTime dateTime, EnumSet<Fields> fields, boolean withOffset) {
        XMLGregorianCalendar calendar = null;
        if (dateTime != null) {
            calendar = XML_TYPE_FACTORY.newXMLGregorianCalendar(fields.contains((Object)Fields.YEAR) ? dateTime.getYear() : Integer.MIN_VALUE, fields.contains((Object)Fields.MONTH) ? dateTime.getMonthValue() : Integer.MIN_VALUE, fields.contains((Object)Fields.DAY) ? dateTime.getDayOfMonth() : Integer.MIN_VALUE, fields.contains((Object)Fields.HOUR) ? dateTime.getHour() : Integer.MIN_VALUE, fields.contains((Object)Fields.MINUTE) ? dateTime.getMinute() : Integer.MIN_VALUE, fields.contains((Object)Fields.SECOND) ? dateTime.getSecond() : Integer.MIN_VALUE, Integer.MIN_VALUE, withOffset && fields.contains((Object)Fields.TIMEZONE) ? dateTime.getOffset().getTotalSeconds() / 60 : Integer.MIN_VALUE);
            if (fields.contains((Object)Fields.NANO) && dateTime.getNano() != 0) {
                calendar.setFractionalSecond(BigDecimal.valueOf(dateTime.getNano(), 9).stripTrailingZeros());
            }
        }
        return calendar;
    }

    public static void setZoneOffsetProvider(Function<LocalDateTime, ZoneOffset> zoneOffsetProvider) {
        if (zoneOffsetProvider != null) {
            ZONE_OFFSET_PROVIDER = zoneOffsetProvider;
        }
    }

    public static void serializeTimeWithOffset(boolean useTimeOffset) {
        WITH_TIME_OFFSET = useTimeOffset;
    }

    public static void serializeDateWithOffset(boolean useDateOffset) {
        WITH_DATE_OFFSET = useDateOffset;
    }

    private String trimmedContent() {
        if (this.trimmedContent == null) {
            this.trimmedContent = this.content.trim();
        }
        return this.trimmedContent;
    }

    private int tokenizeContent() {
        if (this.tokenizedContent == null) {
            int next;
            int length = this.content.length();
            String[] tokens = new String[length / 2 + 1];
            int noOfTokens = 0;
            int current = -1;
            do {
                if ((next = this.nextWhiteSpace(this.content, current + 1, length)) != current + 1) {
                    tokens[noOfTokens++] = this.content.substring(current + 1, next);
                }
                current = next;
            } while (next != length);
            this.tokenizedContent = new String[noOfTokens];
            System.arraycopy(tokens, 0, this.tokenizedContent, 0, noOfTokens);
        }
        return this.tokenizedContent.length;
    }

    private int nextWhiteSpace(String value, int pos, int length) {
        for (int i = pos; i < length; ++i) {
            if (!this.isWhiteSpace(value.charAt(i))) continue;
            return i;
        }
        return length;
    }

    private boolean isWhiteSpace(char ch) {
        return ch == ' ' || ch == '\n' || Character.isWhitespace(ch);
    }

    public String toString() {
        return this.content;
    }

    static {
        EMPTY = new TextContent("");
        ZONE_OFFSET_PROVIDER = dateTime -> ZoneOffset.systemDefault().getRules().getOffset((LocalDateTime)dateTime);
        WITH_TIME_OFFSET = true;
        WITH_DATE_OFFSET = false;
        DATE_TIME_FIELDS = EnumSet.allOf(Fields.class);
        TIME_FIELDS = EnumSet.of(Fields.HOUR, Fields.MINUTE, Fields.SECOND, Fields.NANO, Fields.TIMEZONE);
        DATE_FIELDS = EnumSet.of(Fields.YEAR, Fields.MONTH, Fields.DAY, Fields.TIMEZONE);
        GYEAR_MONTH_FIELDS = EnumSet.of(Fields.YEAR, Fields.MONTH, Fields.TIMEZONE);
        GMONTH_DAY_FIELDS = EnumSet.of(Fields.MONTH, Fields.DAY, Fields.TIMEZONE);
        GDAY_FIELDS = EnumSet.of(Fields.DAY, Fields.TIMEZONE);
        GMONTH_FIELDS = EnumSet.of(Fields.MONTH, Fields.TIMEZONE);
        GYEAR_FIELDS = EnumSet.of(Fields.YEAR, Fields.TIMEZONE);
        try {
            XML_TYPE_FACTORY = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException("Failed to initialize datatype factory.", e);
        }
    }

    private static enum Fields {
        YEAR,
        MONTH,
        DAY,
        HOUR,
        MINUTE,
        SECOND,
        NANO,
        TIMEZONE;

    }
}

