/*
 * Decompiled with CFR 0.152.
 */
package so.trophy.resources.achievements;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import so.trophy.core.ClientOptions;
import so.trophy.core.MediaTypes;
import so.trophy.core.ObjectMappers;
import so.trophy.core.RequestOptions;
import so.trophy.core.TrophyApiApiException;
import so.trophy.core.TrophyApiException;
import so.trophy.errors.NotFoundError;
import so.trophy.errors.UnauthorizedError;
import so.trophy.errors.UnprocessableEntityError;
import so.trophy.resources.achievements.requests.AchievementsCompleteRequest;
import so.trophy.types.AchievementCompletionResponse;
import so.trophy.types.ErrorBody;

public class AchievementsClient {
    protected final ClientOptions clientOptions;

    public AchievementsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public AchievementCompletionResponse complete(String key, AchievementsCompleteRequest request) {
        return this.complete(key, request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AchievementCompletionResponse complete(String key, AchievementsCompleteRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("achievements").addPathSegment(key).addPathSegments("complete").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new TrophyApiException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                AchievementCompletionResponse achievementCompletionResponse = (AchievementCompletionResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), AchievementCompletionResponse.class);
                return achievementCompletionResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 401: {
                        throw new UnauthorizedError((ErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ErrorBody.class));
                    }
                    case 404: {
                        throw new NotFoundError((ErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ErrorBody.class));
                    }
                    case 422: {
                        throw new UnprocessableEntityError((ErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ErrorBody.class));
                    }
                }
                throw new TrophyApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new TrophyApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new TrophyApiException("Network error executing HTTP request", e);
        }
    }
}

