/*
 * Decompiled with CFR 0.152.
 */
package so.trophy.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import so.trophy.core.ObjectMappers;
import so.trophy.types.AchievementResponse;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class EventResponseMetricsItem {
    private final Optional<String> metricId;
    private final Optional<List<AchievementResponse>> completed;
    private final Map<String, Object> additionalProperties;

    private EventResponseMetricsItem(Optional<String> metricId, Optional<List<AchievementResponse>> completed, Map<String, Object> additionalProperties) {
        this.metricId = metricId;
        this.completed = completed;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="metricId")
    public Optional<String> getMetricId() {
        return this.metricId;
    }

    @JsonProperty(value="completed")
    public Optional<List<AchievementResponse>> getCompleted() {
        return this.completed;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof EventResponseMetricsItem && this.equalTo((EventResponseMetricsItem)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(EventResponseMetricsItem other) {
        return this.metricId.equals(other.metricId) && this.completed.equals(other.completed);
    }

    public int hashCode() {
        return Objects.hash(this.metricId, this.completed);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> metricId = Optional.empty();
        private Optional<List<AchievementResponse>> completed = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(EventResponseMetricsItem other) {
            this.metricId(other.getMetricId());
            this.completed(other.getCompleted());
            return this;
        }

        @JsonSetter(value="metricId", nulls=Nulls.SKIP)
        public Builder metricId(Optional<String> metricId) {
            this.metricId = metricId;
            return this;
        }

        public Builder metricId(String metricId) {
            this.metricId = Optional.ofNullable(metricId);
            return this;
        }

        @JsonSetter(value="completed", nulls=Nulls.SKIP)
        public Builder completed(Optional<List<AchievementResponse>> completed) {
            this.completed = completed;
            return this;
        }

        public Builder completed(List<AchievementResponse> completed) {
            this.completed = Optional.ofNullable(completed);
            return this;
        }

        public EventResponseMetricsItem build() {
            return new EventResponseMetricsItem(this.metricId, this.completed, this.additionalProperties);
        }
    }
}

