/*
 * Decompiled with CFR 0.152.
 */
package so.trophy.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import so.trophy.core.ObjectMappers;
import so.trophy.types.IUpdatedUser;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpdatedUser
implements IUpdatedUser {
    private final Optional<String> email;
    private final Optional<String> name;
    private final Optional<String> tz;
    private final Optional<Boolean> subscribeToEmails;
    private final Map<String, Object> additionalProperties;

    private UpdatedUser(Optional<String> email, Optional<String> name, Optional<String> tz, Optional<Boolean> subscribeToEmails, Map<String, Object> additionalProperties) {
        this.email = email;
        this.name = name;
        this.tz = tz;
        this.subscribeToEmails = subscribeToEmails;
        this.additionalProperties = additionalProperties;
    }

    @Override
    @JsonProperty(value="email")
    public Optional<String> getEmail() {
        return this.email;
    }

    @Override
    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="tz")
    public Optional<String> getTz() {
        return this.tz;
    }

    @Override
    @JsonProperty(value="subscribeToEmails")
    public Optional<Boolean> getSubscribeToEmails() {
        return this.subscribeToEmails;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpdatedUser && this.equalTo((UpdatedUser)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdatedUser other) {
        return this.email.equals(other.email) && this.name.equals(other.name) && this.tz.equals(other.tz) && this.subscribeToEmails.equals(other.subscribeToEmails);
    }

    public int hashCode() {
        return Objects.hash(this.email, this.name, this.tz, this.subscribeToEmails);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> email = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<String> tz = Optional.empty();
        private Optional<Boolean> subscribeToEmails = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(UpdatedUser other) {
            this.email(other.getEmail());
            this.name(other.getName());
            this.tz(other.getTz());
            this.subscribeToEmails(other.getSubscribeToEmails());
            return this;
        }

        @JsonSetter(value="email", nulls=Nulls.SKIP)
        public Builder email(Optional<String> email) {
            this.email = email;
            return this;
        }

        public Builder email(String email) {
            this.email = Optional.ofNullable(email);
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @JsonSetter(value="tz", nulls=Nulls.SKIP)
        public Builder tz(Optional<String> tz) {
            this.tz = tz;
            return this;
        }

        public Builder tz(String tz) {
            this.tz = Optional.ofNullable(tz);
            return this;
        }

        @JsonSetter(value="subscribeToEmails", nulls=Nulls.SKIP)
        public Builder subscribeToEmails(Optional<Boolean> subscribeToEmails) {
            this.subscribeToEmails = subscribeToEmails;
            return this;
        }

        public Builder subscribeToEmails(Boolean subscribeToEmails) {
            this.subscribeToEmails = Optional.ofNullable(subscribeToEmails);
            return this;
        }

        public UpdatedUser build() {
            return new UpdatedUser(this.email, this.name, this.tz, this.subscribeToEmails, this.additionalProperties);
        }
    }
}

