/*
 * Decompiled with CFR 0.152.
 */
package software.nectar.java.factory;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import org.json.JSONObject;
import software.nectar.java.factory.base.BaseFactory;
import software.nectar.java.factory.base.exceptions.ApiResponseException;
import software.nectar.java.models.User;
import software.nectar.java.utils.Payload;

public class UsersFactory
extends BaseFactory<User> {
    private final String USERS_PATH = "/v1/users";

    public UsersFactory(String key, String secret) {
        super(key, secret);
    }

    public String createUser(String firstName, String lastName, String username, String password, String phoneNo, String imageUrl, String email, boolean activated) throws NoSuchAlgorithmException, InvalidKeyException, IOException, ApiResponseException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("first_name", firstName);
        params.put("last_name", lastName);
        params.put("username", username);
        params.put("password", password);
        params.put("phone_no", phoneNo);
        params.put("image_url", imageUrl);
        params.put("email", email);
        params.put("activated", activated);
        JSONObject resp = this.post("/v1/users", new Payload(params), "application/json");
        if ((Integer)((JSONObject)resp.get("status")).get("code") == 200) {
            return (String)((JSONObject)resp.get("data")).get("user_ref");
        }
        throw new ApiResponseException(String.format("Status Code %d %s", ((JSONObject)resp.get("status")).get("code"), ((JSONObject)resp.get("status")).get("message")));
    }

    public User getUser() throws NoSuchAlgorithmException, InvalidKeyException, IOException, ApiResponseException {
        return this.extractFrom(this.get("/v1/users", "", "application/json"));
    }

    public void updateUser(String firstName, String lastName, String username, String password, String phoneNo, String imageUrl, String email, boolean activated) throws NoSuchAlgorithmException, InvalidKeyException, IOException, ApiResponseException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("first_name", firstName);
        params.put("last_name", lastName);
        params.put("username", username);
        params.put("password", password);
        params.put("phone_no", phoneNo);
        params.put("image_url", imageUrl);
        params.put("email", email);
        params.put("activated", activated);
        JSONObject resp = this.put("/v1/users", "", new Payload(params), "application/json");
    }

    public void deleteUser() throws NoSuchAlgorithmException, InvalidKeyException, IOException, ApiResponseException {
        this.delete("/v1/users", "", "application/json");
    }

    @Override
    public List<User> extractMultipleFrom(JSONObject responseObj) throws ApiResponseException {
        return null;
    }

    @Override
    public User extractFrom(JSONObject responseObj) throws ApiResponseException {
        if (responseObj.getJSONObject("status").getInt("code") == 200) {
            JSONObject user = responseObj.getJSONObject("data").getJSONObject("data");
            return new User((String)user.get("first_name"), (String)user.get("last_name"), (String)user.get("username"), "", (String)user.get("phone_no"), user.get("image_url") != JSONObject.NULL ? (String)user.get("image_url") : "", (String)user.get("ref"), (String)user.get("email"), (Boolean)user.get("activated"), Instant.parse((String)user.get("created_at")));
        }
        throw new ApiResponseException(responseObj.getJSONObject("status").getString("message"));
    }
}

