/*
 * Decompiled with CFR 0.152.
 */
package software.nectar.java.utils;

import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class AsymmetricEncryptUtils {
    protected static final String ALGORITHM = "RSA";

    public static void init() {
        Security.addProvider((Provider)new BouncyCastleProvider());
        Security.setProperty("crypto.policy", "unlimited");
    }

    public static String encrypt(String text, Key key) throws Exception {
        byte[] cipherText = AsymmetricEncryptUtils.encrypt(text.getBytes("UTF8"), key);
        String encryptedText = AsymmetricEncryptUtils.encodeBASE64(cipherText);
        return encryptedText;
    }

    public static byte[] encrypt(byte[] text, Key key) throws Exception {
        AsymmetricEncryptUtils.init();
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(1, key);
        return cipher.doFinal(text);
    }

    public static String decrypt(String text, Key key) throws Exception {
        byte[] decryptedText = AsymmetricEncryptUtils.decrypt(AsymmetricEncryptUtils.decodeBASE64(text), key);
        String result = new String(decryptedText, "UTF8");
        return result;
    }

    public static byte[] decrypt(byte[] text, Key key) throws Exception {
        AsymmetricEncryptUtils.init();
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(2, key);
        return cipher.doFinal(text);
    }

    public static String getKeyAsString(Key key) {
        byte[] keyBytes = key.getEncoded();
        return AsymmetricEncryptUtils.encodeBASE64(keyBytes);
    }

    public static PrivateKey getPrivateKeyFromString(String key) throws Exception {
        AsymmetricEncryptUtils.init();
        KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
        PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(AsymmetricEncryptUtils.decodeBASE64(key));
        PrivateKey privateKey = keyFactory.generatePrivate(privateKeySpec);
        return privateKey;
    }

    public static PublicKey getPublicKeyFromString(String key) throws Exception {
        AsymmetricEncryptUtils.init();
        KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
        X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(AsymmetricEncryptUtils.decodeBASE64(key));
        PublicKey publicKey = keyFactory.generatePublic(publicKeySpec);
        return publicKey;
    }

    public static String encodeBASE64(byte[] bytes) {
        return Base64.encodeBase64String((byte[])bytes);
    }

    public static byte[] decodeBASE64(String text) {
        return Base64.decodeBase64((String)text);
    }
}

