/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate.support;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.transaction.Synchronization;
import javax.transaction.TransactionManager;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.UserType;
import net.sf.hibernate.util.EqualsHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.jdbc.support.lob.LobCreator;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.orm.hibernate.LocalSessionFactoryBean;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public abstract class AbstractLobType
implements UserType {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final LobHandler lobHandler;
    private final TransactionManager jtaTransactionManager;

    protected AbstractLobType() {
        this(LocalSessionFactoryBean.getConfigTimeLobHandler(), LocalSessionFactoryBean.getConfigTimeTransactionManager());
    }

    protected AbstractLobType(LobHandler lobHandler, TransactionManager jtaTransactionManager) {
        this.lobHandler = lobHandler;
        this.jtaTransactionManager = jtaTransactionManager;
    }

    public boolean isMutable() {
        return false;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        return EqualsHelper.equals((Object)x, (Object)y);
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public final Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws HibernateException, SQLException {
        if (this.lobHandler == null) {
            throw new IllegalStateException("No LobHandler found for configuration - lobHandler property must be set on LocalSessionFactoryBean");
        }
        try {
            return this.nullSafeGetInternal(rs, rs.findColumn(names[0]), this.lobHandler);
        }
        catch (IOException ex) {
            throw new HibernateException("I/O errors during LOB access", (Throwable)ex);
        }
    }

    public final void nullSafeSet(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        if (this.lobHandler == null) {
            throw new IllegalStateException("No LobHandler found for configuration - lobHandler property must be set on LocalSessionFactoryBean");
        }
        LobCreator lobCreator = this.lobHandler.getLobCreator();
        try {
            this.nullSafeSetInternal(st, index, value, lobCreator);
        }
        catch (IOException ex) {
            throw new HibernateException("I/O errors during LOB access", (Throwable)ex);
        }
        if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            if (this.jtaTransactionManager != null) {
                try {
                    int jtaStatus = this.jtaTransactionManager.getStatus();
                    if (jtaStatus == 0 || jtaStatus == 1) {
                        this.logger.debug((Object)"Registering JTA transaction synchronization for Hibernate LOB type");
                        this.jtaTransactionManager.getTransaction().registerSynchronization((Synchronization)new JtaLobCreatorSynchronization(lobCreator));
                        return;
                    }
                }
                catch (Exception ex) {
                    throw new DataAccessResourceFailureException("Could not register synchronization with JTA TransactionManager", (Throwable)ex);
                }
            }
            throw new IllegalStateException("Active Spring transaction synchronization or jtaTransactionManager on LocalSessionFactoryBean plus active JTA transaction required");
        }
        this.logger.debug((Object)"Registering Spring transaction synchronization for Hibernate LOB type");
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new SpringLobCreatorSynchronization(lobCreator));
    }

    protected abstract Object nullSafeGetInternal(ResultSet var1, int var2, LobHandler var3) throws SQLException, IOException, HibernateException;

    protected abstract void nullSafeSetInternal(PreparedStatement var1, int var2, Object var3, LobCreator var4) throws SQLException, IOException, HibernateException;

    private static class JtaLobCreatorSynchronization
    implements Synchronization {
        private final LobCreator lobCreator;

        public JtaLobCreatorSynchronization(LobCreator lobCreator) {
            this.lobCreator = lobCreator;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            this.lobCreator.close();
        }
    }

    private static class SpringLobCreatorSynchronization
    extends TransactionSynchronizationAdapter {
        private final LobCreator lobCreator;

        private SpringLobCreatorSynchronization(LobCreator lobCreator) {
            this.lobCreator = lobCreator;
        }

        public void beforeCompletion() {
            this.lobCreator.close();
        }
    }
}

