package com.checkhim.exceptions;

/**
 * Exception thrown when the subscriber is temporarily absent or unreachable.
 * 
 * This typically occurs when the phone is turned off, out of coverage,
 * or temporarily unable to receive messages.
 */
public class SubscriberAbsentException extends CheckHimException {

    /**
     * Creates a new SubscriberAbsentException.
     *
     * @param message The error message
     * @param httpStatusCode The HTTP status code
     */
    public SubscriberAbsentException(String message, int httpStatusCode) {
        super(message, "REJECTED_SUBSCRIBER_ABSENT", httpStatusCode);
    }

    /**
     * Creates a new SubscriberAbsentException with a cause.
     *
     * @param message The error message
     * @param httpStatusCode The HTTP status code
     * @param cause The underlying cause
     */
    public SubscriberAbsentException(String message, int httpStatusCode, Throwable cause) {
        super(message, "REJECTED_SUBSCRIBER_ABSENT", httpStatusCode, cause);
    }
}