package com.checkhim.exceptions;

/**
 * Exception thrown when the subscriber is unknown to the network.
 * 
 * This occurs when the phone number doesn't exist in the network
 * or is not recognized by the carrier.
 */
public class UnknownSubscriberException extends CheckHimException {

    /**
     * Creates a new UnknownSubscriberException.
     *
     * @param message The error message
     * @param httpStatusCode The HTTP status code
     */
    public UnknownSubscriberException(String message, int httpStatusCode) {
        super(message, "REJECTED_UNKNOWN_SUBSCRIBER", httpStatusCode);
    }

    /**
     * Creates a new UnknownSubscriberException with a cause.
     *
     * @param message The error message
     * @param httpStatusCode The HTTP status code
     * @param cause The underlying cause
     */
    public UnknownSubscriberException(String message, int httpStatusCode, Throwable cause) {
        super(message, "REJECTED_UNKNOWN_SUBSCRIBER", httpStatusCode, cause);
    }
}